/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.MenuOpenGUIProcedure;
import mc.sayda.creraces.procedures.Race2OpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceDragonbornOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceDwarfOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceElementalistOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceFairyOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceGolemOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceHarpyOpenGuiProcedure;
import mc.sayda.creraces.procedures.RaceHumanOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceMermaidOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceUndeadOpenGUIProcedure;
import mc.sayda.creraces.world.inventory.Race1GUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Race1GUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public Race1GUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public Race1GUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(Race1GUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(Race1GUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            Race1GUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = Race1GUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MenuOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            Race2OpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            RaceHumanOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            RaceUndeadOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            RaceDwarfOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            RaceDragonbornOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            RaceHarpyOpenGuiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            RaceFairyOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            RaceMermaidOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            RaceElementalistOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            RaceGolemOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(Race1GUIButtonMessage.class, Race1GUIButtonMessage::buffer, Race1GUIButtonMessage::new, Race1GUIButtonMessage::handler);
    }
}

