/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mc.sayda.creraces.init.CreracesModBiomes;
import mc.sayda.creraces.init.CreracesModBlockEntities;
import mc.sayda.creraces.init.CreracesModBlocks;
import mc.sayda.creraces.init.CreracesModEnchantments;
import mc.sayda.creraces.init.CreracesModEntities;
import mc.sayda.creraces.init.CreracesModFluidTypes;
import mc.sayda.creraces.init.CreracesModFluids;
import mc.sayda.creraces.init.CreracesModItems;
import mc.sayda.creraces.init.CreracesModMenus;
import mc.sayda.creraces.init.CreracesModMobEffects;
import mc.sayda.creraces.init.CreracesModParticleTypes;
import mc.sayda.creraces.init.CreracesModPotions;
import mc.sayda.creraces.init.CreracesModSounds;
import mc.sayda.creraces.init.CreracesModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="creraces")
public class CreracesMod {
    public static final Logger LOGGER = LogManager.getLogger(CreracesMod.class);
    public static final String MODID = "creraces";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("creraces", "creraces"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public CreracesMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        CreracesModTabs.load();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CreracesModSounds.REGISTRY.register(bus);
        CreracesModBlocks.REGISTRY.register(bus);
        CreracesModItems.REGISTRY.register(bus);
        CreracesModEntities.REGISTRY.register(bus);
        CreracesModBlockEntities.REGISTRY.register(bus);
        CreracesModEnchantments.REGISTRY.register(bus);
        CreracesModParticleTypes.REGISTRY.register(bus);
        CreracesModMobEffects.REGISTRY.register(bus);
        CreracesModPotions.REGISTRY.register(bus);
        CreracesModMenus.REGISTRY.register(bus);
        CreracesModBiomes.REGISTRY.register(bus);
        CreracesModFluids.REGISTRY.register(bus);
        CreracesModFluidTypes.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

