/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.function.Supplier;
import mc.sayda.creraces.CreracesMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CreracesModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        CreracesMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.ButtonPos = message.data.ButtonPos;
                    variables.ClassUpdate = message.data.ClassUpdate;
                    variables.guideGiven = message.data.guideGiven;
                    variables.HasChoosenRace = message.data.HasChoosenRace;
                    variables.HasChoosenSubRace = message.data.HasChoosenSubRace;
                    variables.HasPocket = message.data.HasPocket;
                    variables.HumanCheck = message.data.HumanCheck;
                    variables.RaceUpdate = message.data.RaceUpdate;
                    variables.showSecretNumpad = message.data.showSecretNumpad;
                    variables.AbilitySwitching = message.data.AbilitySwitching;
                    variables.ShowCDOverlay = message.data.ShowCDOverlay;
                    variables.ShowRaceOverlay = message.data.ShowRaceOverlay;
                    variables.Trail = message.data.Trail;
                    variables.UseHints = message.data.UseHints;
                    variables.A1CD = message.data.A1CD;
                    variables.A2CD = message.data.A2CD;
                    variables.Grit = message.data.Grit;
                    variables.InGUI = message.data.InGUI;
                    variables.IsRace2 = message.data.IsRace2;
                    variables.ItemStacks = message.data.ItemStacks;
                    variables.Karma = message.data.Karma;
                    variables.Mana = message.data.Mana;
                    variables.numNumpad = message.data.numNumpad;
                    variables.PCD = message.data.PCD;
                    variables.RaceAbilityKeep = message.data.RaceAbilityKeep;
                    variables.RaceStyle = message.data.RaceStyle;
                    variables.TempValue1 = message.data.TempValue1;
                    variables.TempValue2 = message.data.TempValue2;
                    variables.TempValue3 = message.data.TempValue3;
                    variables.TempValue4 = message.data.TempValue4;
                    variables.TrailState = message.data.TrailState;
                    variables.WorldStatePlayer = message.data.WorldStatePlayer;
                    variables.AD = message.data.AD;
                    variables.AH = message.data.AH;
                    variables.AP = message.data.AP;
                    variables.Coins = message.data.Coins;
                    variables.CR = message.data.CR;
                    variables.dx = message.data.dx;
                    variables.dy = message.data.dy;
                    variables.dz = message.data.dz;
                    variables.Faction = message.data.Faction;
                    variables.IsRace = message.data.IsRace;
                    variables.PassiveCooldown = message.data.PassiveCooldown;
                    variables.PassiveStacks = message.data.PassiveStacks;
                    variables.px = message.data.px;
                    variables.py = message.data.py;
                    variables.pz = message.data.pz;
                    variables.RaceAbilityToggle = message.data.RaceAbilityToggle;
                    variables.RaceRanking = message.data.RaceRanking;
                    variables.Rage = message.data.Rage;
                    variables.ResourceBar = message.data.ResourceBar;
                    variables.Skill1Level = message.data.Skill1Level;
                    variables.Skill2Level = message.data.Skill2Level;
                    variables.Skill3Level = message.data.Skill3Level;
                    variables.Skill4Level = message.data.Skill4Level;
                    variables.SkillPoints = message.data.SkillPoints;
                    variables.SkillSelect = message.data.SkillSelect;
                    variables.UltimateCooldown = message.data.UltimateCooldown;
                    variables.UltimateCooldown2 = message.data.UltimateCooldown2;
                    variables.PocketSize = message.data.PocketSize;
                    variables.Size = message.data.Size;
                    variables.Energy = message.data.Energy;
                    variables.Soul = message.data.Soul;
                    variables.RaceString = message.data.RaceString;
                    variables.raceTeam = message.data.raceTeam;
                    variables.karmaState = message.data.karmaState;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean ButtonPos = false;
        public boolean ClassUpdate = false;
        public boolean guideGiven = false;
        public boolean HasChoosenRace = false;
        public boolean HasChoosenSubRace = false;
        public boolean HasPocket = false;
        public boolean HumanCheck = false;
        public boolean RaceUpdate = false;
        public boolean showSecretNumpad = false;
        public boolean AbilitySwitching = true;
        public boolean ShowCDOverlay = true;
        public boolean ShowRaceOverlay = true;
        public boolean Trail = true;
        public boolean UseHints = true;
        public double A1CD = 0.0;
        public double A2CD = 0.0;
        public double Grit = 0.0;
        public double InGUI = 0.0;
        public double IsRace2 = 0.0;
        public double ItemStacks = 0.0;
        public double Karma = 0.0;
        public double Mana = 0.0;
        public double numNumpad = 0.0;
        public double PCD = 0.0;
        public double RaceAbilityKeep = 0.0;
        public double RaceStyle = 0.0;
        public double TempValue1 = 0.0;
        public double TempValue2 = 0.0;
        public double TempValue3 = 0.0;
        public double TempValue4 = 0.0;
        public double TrailState = 0.0;
        public double WorldStatePlayer = 0.0;
        public double AD = 0.0;
        public double AH = 0.0;
        public double AP = 0.0;
        public double Coins = 0.0;
        public double CR = 0.0;
        public double dx = 0.0;
        public double dy = 0.0;
        public double dz = 0.0;
        public double Faction = 0.0;
        public double IsRace = 0.0;
        public double PassiveCooldown = 0.0;
        public double PassiveStacks = 0.0;
        public double px = 0.0;
        public double py = 0.0;
        public double pz = 0.0;
        public double RaceAbilityToggle = 0.0;
        public double RaceRanking = 0.0;
        public double Rage = 0.0;
        public double ResourceBar = 0.0;
        public double Skill1Level = 0.0;
        public double Skill2Level = 0.0;
        public double Skill3Level = 0.0;
        public double Skill4Level = 0.0;
        public double SkillPoints = 0.0;
        public double SkillSelect = 0.0;
        public double UltimateCooldown = 0.0;
        public double UltimateCooldown2 = 0.0;
        public double PocketSize = 1.0;
        public double Size = 1.0;
        public double Energy = 200.0;
        public double Soul = 9.0;
        public String RaceString = "None";
        public String raceTeam = "None";
        public double karmaState = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                CreracesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("ButtonPos", this.ButtonPos);
            nbt.m_128379_("ClassUpdate", this.ClassUpdate);
            nbt.m_128379_("guideGiven", this.guideGiven);
            nbt.m_128379_("HasChoosenRace", this.HasChoosenRace);
            nbt.m_128379_("HasChoosenSubRace", this.HasChoosenSubRace);
            nbt.m_128379_("HasPocket", this.HasPocket);
            nbt.m_128379_("HumanCheck", this.HumanCheck);
            nbt.m_128379_("RaceUpdate", this.RaceUpdate);
            nbt.m_128379_("showSecretNumpad", this.showSecretNumpad);
            nbt.m_128379_("AbilitySwitching", this.AbilitySwitching);
            nbt.m_128379_("ShowCDOverlay", this.ShowCDOverlay);
            nbt.m_128379_("ShowRaceOverlay", this.ShowRaceOverlay);
            nbt.m_128379_("Trail", this.Trail);
            nbt.m_128379_("UseHints", this.UseHints);
            nbt.m_128347_("A1CD", this.A1CD);
            nbt.m_128347_("A2CD", this.A2CD);
            nbt.m_128347_("Grit", this.Grit);
            nbt.m_128347_("InGUI", this.InGUI);
            nbt.m_128347_("IsRace2", this.IsRace2);
            nbt.m_128347_("ItemStacks", this.ItemStacks);
            nbt.m_128347_("Karma", this.Karma);
            nbt.m_128347_("Mana", this.Mana);
            nbt.m_128347_("numNumpad", this.numNumpad);
            nbt.m_128347_("PCD", this.PCD);
            nbt.m_128347_("RaceAbilityKeep", this.RaceAbilityKeep);
            nbt.m_128347_("RaceStyle", this.RaceStyle);
            nbt.m_128347_("TempValue1", this.TempValue1);
            nbt.m_128347_("TempValue2", this.TempValue2);
            nbt.m_128347_("TempValue3", this.TempValue3);
            nbt.m_128347_("TempValue4", this.TempValue4);
            nbt.m_128347_("TrailState", this.TrailState);
            nbt.m_128347_("WorldStatePlayer", this.WorldStatePlayer);
            nbt.m_128347_("AD", this.AD);
            nbt.m_128347_("AH", this.AH);
            nbt.m_128347_("AP", this.AP);
            nbt.m_128347_("Coins", this.Coins);
            nbt.m_128347_("CR", this.CR);
            nbt.m_128347_("dx", this.dx);
            nbt.m_128347_("dy", this.dy);
            nbt.m_128347_("dz", this.dz);
            nbt.m_128347_("Faction", this.Faction);
            nbt.m_128347_("IsRace", this.IsRace);
            nbt.m_128347_("PassiveCooldown", this.PassiveCooldown);
            nbt.m_128347_("PassiveStacks", this.PassiveStacks);
            nbt.m_128347_("px", this.px);
            nbt.m_128347_("py", this.py);
            nbt.m_128347_("pz", this.pz);
            nbt.m_128347_("RaceAbilityToggle", this.RaceAbilityToggle);
            nbt.m_128347_("RaceRanking", this.RaceRanking);
            nbt.m_128347_("Rage", this.Rage);
            nbt.m_128347_("ResourceBar", this.ResourceBar);
            nbt.m_128347_("Skill1Level", this.Skill1Level);
            nbt.m_128347_("Skill2Level", this.Skill2Level);
            nbt.m_128347_("Skill3Level", this.Skill3Level);
            nbt.m_128347_("Skill4Level", this.Skill4Level);
            nbt.m_128347_("SkillPoints", this.SkillPoints);
            nbt.m_128347_("SkillSelect", this.SkillSelect);
            nbt.m_128347_("UltimateCooldown", this.UltimateCooldown);
            nbt.m_128347_("UltimateCooldown2", this.UltimateCooldown2);
            nbt.m_128347_("PocketSize", this.PocketSize);
            nbt.m_128347_("Size", this.Size);
            nbt.m_128347_("Energy", this.Energy);
            nbt.m_128347_("Soul", this.Soul);
            nbt.m_128359_("RaceString", this.RaceString);
            nbt.m_128359_("raceTeam", this.raceTeam);
            nbt.m_128347_("karmaState", this.karmaState);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.ButtonPos = nbt.m_128471_("ButtonPos");
            this.ClassUpdate = nbt.m_128471_("ClassUpdate");
            this.guideGiven = nbt.m_128471_("guideGiven");
            this.HasChoosenRace = nbt.m_128471_("HasChoosenRace");
            this.HasChoosenSubRace = nbt.m_128471_("HasChoosenSubRace");
            this.HasPocket = nbt.m_128471_("HasPocket");
            this.HumanCheck = nbt.m_128471_("HumanCheck");
            this.RaceUpdate = nbt.m_128471_("RaceUpdate");
            this.showSecretNumpad = nbt.m_128471_("showSecretNumpad");
            this.AbilitySwitching = nbt.m_128471_("AbilitySwitching");
            this.ShowCDOverlay = nbt.m_128471_("ShowCDOverlay");
            this.ShowRaceOverlay = nbt.m_128471_("ShowRaceOverlay");
            this.Trail = nbt.m_128471_("Trail");
            this.UseHints = nbt.m_128471_("UseHints");
            this.A1CD = nbt.m_128459_("A1CD");
            this.A2CD = nbt.m_128459_("A2CD");
            this.Grit = nbt.m_128459_("Grit");
            this.InGUI = nbt.m_128459_("InGUI");
            this.IsRace2 = nbt.m_128459_("IsRace2");
            this.ItemStacks = nbt.m_128459_("ItemStacks");
            this.Karma = nbt.m_128459_("Karma");
            this.Mana = nbt.m_128459_("Mana");
            this.numNumpad = nbt.m_128459_("numNumpad");
            this.PCD = nbt.m_128459_("PCD");
            this.RaceAbilityKeep = nbt.m_128459_("RaceAbilityKeep");
            this.RaceStyle = nbt.m_128459_("RaceStyle");
            this.TempValue1 = nbt.m_128459_("TempValue1");
            this.TempValue2 = nbt.m_128459_("TempValue2");
            this.TempValue3 = nbt.m_128459_("TempValue3");
            this.TempValue4 = nbt.m_128459_("TempValue4");
            this.TrailState = nbt.m_128459_("TrailState");
            this.WorldStatePlayer = nbt.m_128459_("WorldStatePlayer");
            this.AD = nbt.m_128459_("AD");
            this.AH = nbt.m_128459_("AH");
            this.AP = nbt.m_128459_("AP");
            this.Coins = nbt.m_128459_("Coins");
            this.CR = nbt.m_128459_("CR");
            this.dx = nbt.m_128459_("dx");
            this.dy = nbt.m_128459_("dy");
            this.dz = nbt.m_128459_("dz");
            this.Faction = nbt.m_128459_("Faction");
            this.IsRace = nbt.m_128459_("IsRace");
            this.PassiveCooldown = nbt.m_128459_("PassiveCooldown");
            this.PassiveStacks = nbt.m_128459_("PassiveStacks");
            this.px = nbt.m_128459_("px");
            this.py = nbt.m_128459_("py");
            this.pz = nbt.m_128459_("pz");
            this.RaceAbilityToggle = nbt.m_128459_("RaceAbilityToggle");
            this.RaceRanking = nbt.m_128459_("RaceRanking");
            this.Rage = nbt.m_128459_("Rage");
            this.ResourceBar = nbt.m_128459_("ResourceBar");
            this.Skill1Level = nbt.m_128459_("Skill1Level");
            this.Skill2Level = nbt.m_128459_("Skill2Level");
            this.Skill3Level = nbt.m_128459_("Skill3Level");
            this.Skill4Level = nbt.m_128459_("Skill4Level");
            this.SkillPoints = nbt.m_128459_("SkillPoints");
            this.SkillSelect = nbt.m_128459_("SkillSelect");
            this.UltimateCooldown = nbt.m_128459_("UltimateCooldown");
            this.UltimateCooldown2 = nbt.m_128459_("UltimateCooldown2");
            this.PocketSize = nbt.m_128459_("PocketSize");
            this.Size = nbt.m_128459_("Size");
            this.Energy = nbt.m_128459_("Energy");
            this.Soul = nbt.m_128459_("Soul");
            this.RaceString = nbt.m_128461_("RaceString");
            this.raceTeam = nbt.m_128461_("raceTeam");
            this.karmaState = nbt.m_128459_("karmaState");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("creraces", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "creraces_mapvars";
        public boolean UseCustomRaces = false;
        public boolean AllowA1 = true;
        public boolean AllowA2 = true;
        public double ratdenX = 0.0;
        public double ratdenY = 0.0;
        public double ratdenZ = 0.0;
        public double WorldState = 0.0;
        public double TotalGates = 0.0;
        public double TotalPockets = 1.0;
        public String RatKing = "None";
        public double runicCode = 0.0;
        public ListTag maskWarnings = new ListTag();
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            ListTag maskWarnings;
            this.UseCustomRaces = nbt.m_128471_("UseCustomRaces");
            this.AllowA1 = nbt.m_128471_("AllowA1");
            this.AllowA2 = nbt.m_128471_("AllowA2");
            this.ratdenX = nbt.m_128459_("ratdenX");
            this.ratdenY = nbt.m_128459_("ratdenY");
            this.ratdenZ = nbt.m_128459_("ratdenZ");
            this.WorldState = nbt.m_128459_("WorldState");
            this.TotalGates = nbt.m_128459_("TotalGates");
            this.TotalPockets = nbt.m_128459_("TotalPockets");
            this.RatKing = nbt.m_128461_("RatKing");
            this.runicCode = nbt.m_128459_("runicCode");
            Tag tag = nbt.m_128423_("maskWarnings");
            this.maskWarnings = tag instanceof ListTag ? (maskWarnings = (ListTag)tag) : new ListTag();
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("UseCustomRaces", this.UseCustomRaces);
            nbt.m_128379_("AllowA1", this.AllowA1);
            nbt.m_128379_("AllowA2", this.AllowA2);
            nbt.m_128347_("ratdenX", this.ratdenX);
            nbt.m_128347_("ratdenY", this.ratdenY);
            nbt.m_128347_("ratdenZ", this.ratdenZ);
            nbt.m_128347_("WorldState", this.WorldState);
            nbt.m_128347_("TotalGates", this.TotalGates);
            nbt.m_128347_("TotalPockets", this.TotalPockets);
            nbt.m_128359_("RatKing", this.RatKing);
            nbt.m_128347_("runicCode", this.runicCode);
            nbt.m_128365_("maskWarnings", (Tag)this.maskWarnings);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                CreracesMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "creraces_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                CreracesMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.ButtonPos = original.ButtonPos;
            clone.ClassUpdate = original.ClassUpdate;
            clone.HasChoosenRace = original.HasChoosenRace;
            clone.HasChoosenSubRace = original.HasChoosenSubRace;
            clone.HasPocket = original.HasPocket;
            clone.HumanCheck = original.HumanCheck;
            clone.RaceUpdate = original.RaceUpdate;
            clone.AbilitySwitching = original.AbilitySwitching;
            clone.ShowCDOverlay = original.ShowCDOverlay;
            clone.ShowRaceOverlay = original.ShowRaceOverlay;
            clone.Trail = original.Trail;
            clone.UseHints = original.UseHints;
            clone.A1CD = original.A1CD;
            clone.A2CD = original.A2CD;
            clone.IsRace2 = original.IsRace2;
            clone.ItemStacks = original.ItemStacks;
            clone.Karma = original.Karma;
            clone.Mana = original.Mana;
            clone.PCD = original.PCD;
            clone.RaceAbilityKeep = original.RaceAbilityKeep;
            clone.RaceStyle = original.RaceStyle;
            clone.TrailState = original.TrailState;
            clone.AD = original.AD;
            clone.AH = original.AH;
            clone.AP = original.AP;
            clone.Coins = original.Coins;
            clone.CR = original.CR;
            clone.dx = original.dx;
            clone.dy = original.dy;
            clone.dz = original.dz;
            clone.Faction = original.Faction;
            clone.IsRace = original.IsRace;
            clone.PassiveStacks = original.PassiveStacks;
            clone.px = original.px;
            clone.py = original.py;
            clone.pz = original.pz;
            clone.RaceRanking = original.RaceRanking;
            clone.ResourceBar = original.ResourceBar;
            clone.Skill1Level = original.Skill1Level;
            clone.Skill2Level = original.Skill2Level;
            clone.Skill3Level = original.Skill3Level;
            clone.Skill4Level = original.Skill4Level;
            clone.SkillPoints = original.SkillPoints;
            clone.SkillSelect = original.SkillSelect;
            clone.PocketSize = original.PocketSize;
            clone.Size = original.Size;
            clone.Soul = original.Soul;
            clone.RaceString = original.RaceString;
            clone.raceTeam = original.raceTeam;
            clone.karmaState = original.karmaState;
            if (!event.isWasDeath()) {
                clone.guideGiven = original.guideGiven;
                clone.showSecretNumpad = original.showSecretNumpad;
                clone.Grit = original.Grit;
                clone.InGUI = original.InGUI;
                clone.numNumpad = original.numNumpad;
                clone.TempValue1 = original.TempValue1;
                clone.TempValue2 = original.TempValue2;
                clone.TempValue3 = original.TempValue3;
                clone.TempValue4 = original.TempValue4;
                clone.WorldStatePlayer = original.WorldStatePlayer;
                clone.PassiveCooldown = original.PassiveCooldown;
                clone.RaceAbilityToggle = original.RaceAbilityToggle;
                clone.Rage = original.Rage;
                clone.UltimateCooldown = original.UltimateCooldown;
                clone.UltimateCooldown2 = original.UltimateCooldown2;
                clone.Energy = original.Energy;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    CreracesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    CreracesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                CreracesMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

