/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.HashMap;
import java.util.function.Supplier;
import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.MirrorSelect0Procedure;
import mc.sayda.creraces.procedures.MirrorSelect1Procedure;
import mc.sayda.creraces.procedures.MirrorSelect2Procedure;
import mc.sayda.creraces.procedures.MirrorSelect3Procedure;
import mc.sayda.creraces.procedures.MirrorSelect4Procedure;
import mc.sayda.creraces.procedures.MirrorSelect5Procedure;
import mc.sayda.creraces.procedures.MirrorSelect6Procedure;
import mc.sayda.creraces.procedures.MirrorSelectProcedure;
import mc.sayda.creraces.world.inventory.MirrorGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MirrorGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MirrorGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MirrorGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MirrorGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MirrorGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MirrorGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MirrorGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MirrorSelectProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            MirrorSelect1Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            MirrorSelect2Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            MirrorSelect3Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            MirrorSelect4Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            MirrorSelect5Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            MirrorSelect6Procedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            MirrorSelect0Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(MirrorGUIButtonMessage.class, MirrorGUIButtonMessage::buffer, MirrorGUIButtonMessage::new, MirrorGUIButtonMessage::handler);
    }
}

