/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import mc.sayda.creraces.network.SpecialRaceAccessGUIButtonMessage;
import mc.sayda.creraces.world.inventory.SpecialRaceAccessGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class SpecialRaceAccessGUIScreen
extends AbstractContainerScreen<SpecialRaceAccessGUIMenu> {
    private static final HashMap<String, Object> guistate = SpecialRaceAccessGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    EditBox code;
    Button button_back;
    Button button_validate;

    public SpecialRaceAccessGUIScreen(SpecialRaceAccessGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.code.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.code.isFocused()) {
            return this.code.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String codeValue = this.code.getValue();
        super.resize(minecraft, width, height);
        this.code.setValue(codeValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.creraces.special_race_access_gui.label_enter_a_special_race_code"), 23, 10, -1, false);
    }

    public void init() {
        super.init();
        this.code = new EditBox(this, this.font, this.leftPos + 27, this.topPos + 26, 118, 18, (Component)Component.translatable((String)"gui.creraces.special_race_access_gui.code")){

            public void insertText(String text) {
                super.insertText(text);
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.creraces.special_race_access_gui.code").getString());
                } else {
                    this.setSuggestion(null);
                }
            }

            public void moveCursorTo(int pos, boolean flag) {
                super.moveCursorTo(pos, flag);
                if (this.getValue().isEmpty()) {
                    this.setSuggestion(Component.translatable((String)"gui.creraces.special_race_access_gui.code").getString());
                } else {
                    this.setSuggestion(null);
                }
            }
        };
        this.code.setMaxLength(Short.MAX_VALUE);
        this.code.setSuggestion(Component.translatable((String)"gui.creraces.special_race_access_gui.code").getString());
        guistate.put("text:code", this.code);
        this.addWidget((GuiEventListener)this.code);
        this.button_back = Button.builder((Component)Component.translatable((String)"gui.creraces.special_race_access_gui.button_back"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new SpecialRaceAccessGUIButtonMessage(0, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SpecialRaceAccessGUIButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }).bounds(this.leftPos + -120, this.topPos + 178, 55, 20).build();
        guistate.put("button:button_back", this.button_back);
        this.addRenderableWidget((GuiEventListener)this.button_back);
        this.button_validate = Button.builder((Component)Component.translatable((String)"gui.creraces.special_race_access_gui.button_validate"), e -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new SpecialRaceAccessGUIButtonMessage(1, this.x, this.y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SpecialRaceAccessGUIButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
        }).bounds(this.leftPos + 56, this.topPos + 51, 65, 20).build();
        guistate.put("button:button_validate", this.button_validate);
        this.addRenderableWidget((GuiEventListener)this.button_validate);
    }
}

