/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import mc.sayda.creraces.procedures.ShowGhoulProcedure;
import mc.sayda.creraces.procedures.UndeadSummonGUIReturnBootsProcedure;
import mc.sayda.creraces.procedures.UndeadSummonGUIReturnChestplateProcedure;
import mc.sayda.creraces.procedures.UndeadSummonGUIReturnHelmetProcedure;
import mc.sayda.creraces.procedures.UndeadSummonGUIReturnLeggingsProcedure;
import mc.sayda.creraces.procedures.UndeadSummonGUIReturnMainProcedure;
import mc.sayda.creraces.procedures.UndeadSummonGUIReturnOffProcedure;
import mc.sayda.creraces.world.inventory.UndeadSummonGUIMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class UndeadSummonGUIScreen
extends AbstractContainerScreen<UndeadSummonGUIMenu> {
    private static final HashMap<String, Object> guistate = UndeadSummonGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;

    public UndeadSummonGUIScreen(UndeadSummonGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ShowGhoulProcedure.execute((LevelAccessor)this.world, (Entity)this.entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 50, this.topPos + 72, 30, 0.0f + (float)Math.atan((double)(this.leftPos + 50 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 23 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(new ResourceLocation("creraces:textures/screens/undead_summon_gui.png"), this.leftPos + 0, this.topPos + 0, 0.0f, 0.0f, 176, 166, 176, 166);
        if (UndeadSummonGUIReturnHelmetProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(new ResourceLocation("creraces:textures/screens/empty_armor_slot_helmet.png"), this.leftPos + 8, this.topPos + 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (UndeadSummonGUIReturnChestplateProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(new ResourceLocation("creraces:textures/screens/empty_armor_slot_chestplate.png"), this.leftPos + 8, this.topPos + 26, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (UndeadSummonGUIReturnLeggingsProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(new ResourceLocation("creraces:textures/screens/empty_armor_slot_leggings.png"), this.leftPos + 8, this.topPos + 44, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (UndeadSummonGUIReturnBootsProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(new ResourceLocation("creraces:textures/screens/empty_armor_slot_boots.png"), this.leftPos + 8, this.topPos + 62, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (UndeadSummonGUIReturnMainProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(new ResourceLocation("creraces:textures/screens/empty_slot_sword.png"), this.leftPos + 77, this.topPos + 44, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (UndeadSummonGUIReturnOffProcedure.execute((Entity)this.entity)) {
            guiGraphics.blit(new ResourceLocation("creraces:textures/screens/empty_armor_slot_shield.png"), this.leftPos + 77, this.topPos + 62, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void init() {
        super.init();
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (float)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

