/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.entity;

import mc.sayda.creraces.entity.Ranger3EntityProjectile;
import mc.sayda.creraces.init.CreracesModEntities;
import mc.sayda.creraces.procedures.AggressiveModeReturnProcedure;
import mc.sayda.creraces.procedures.FollowModeReturnProcedure;
import mc.sayda.creraces.procedures.PassiveModeReturnProcedure;
import mc.sayda.creraces.procedures.RangerOnTickProcedure;
import mc.sayda.creraces.procedures.SummonChangeModeProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.SpawnPlacementRegisterEvent;

public class Ranger3Entity
extends TamableAnimal
implements RangedAttackMob {
    public Ranger3Entity(EntityType<Ranger3Entity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canUse() && PassiveModeReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canContinueToUse() && PassiveModeReturnProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal(this){

            public boolean canUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canUse() && AggressiveModeReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canContinueToUse() && AggressiveModeReturnProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean canUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canUse() && PassiveModeReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canContinueToUse() && PassiveModeReturnProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new FollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false){

            public boolean canUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canUse() && FollowModeReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canContinueToUse() && FollowModeReturnProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canUse() && PassiveModeReturnProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = Ranger3Entity.this.getX();
                double y = Ranger3Entity.this.getY();
                double z = Ranger3Entity.this.getZ();
                Ranger3Entity entity = Ranger3Entity.this;
                Level world = Ranger3Entity.this.level();
                return super.canContinueToUse() && PassiveModeReturnProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 10.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, (double)-0.35f, 0.0);
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.stray.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.stray.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(new ResourceLocation("entity.stray.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.sidedSuccess((boolean)this.level().isClientSide()) : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Ranger3Entity entity = this;
        Level world = this.level();
        SummonChangeModeProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        RangerOnTickProcedure.execute((LevelAccessor)this.level(), (Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        Ranger3EntityProjectile entityarrow = new Ranger3EntityProjectile((EntityType<? extends Ranger3EntityProjectile>)((EntityType)CreracesModEntities.RANGER_3_PROJECTILE.get()), (LivingEntity)this, this.level());
        double d0 = target.getY() + (double)target.getEyeHeight() - 1.1;
        double d1 = target.getX() - this.getX();
        double d3 = target.getZ() - this.getZ();
        entityarrow.shoot(d1, d0 - entityarrow.getY() + Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f, d3, 1.6f, 12.0f);
        this.level().addFreshEntity((Entity)entityarrow);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        Ranger3Entity retval = (Ranger3Entity)((EntityType)CreracesModEntities.RANGER_3.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of().test(stack);
    }

    public static void init(SpawnPlacementRegisterEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 8.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

