/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.item;

import java.util.List;
import mc.sayda.creraces.procedures.ShowItemStacksProcedure;
import mc.sayda.creraces.procedures.VoidTearItemCheckProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VoidTearItem
extends Item {
    public VoidTearItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.EAT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a79+ 5 AP"));
        list.add((Component)Component.literal((String)"\u00a77Kill 100 entities to level it up!"));
        list.add((Component)Component.literal((String)"\u00a77(It needs to be in your inventory to stack)"));
        list.add((Component)Component.literal((String)"\u00a77(Scaling)"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        ShowItemStacksProcedure.execute((Entity)entity);
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        VoidTearItemCheckProcedure.execute(entity, itemstack);
    }
}

