/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.HashMap;
import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.DevilTearBuyProcedure;
import mc.sayda.creraces.procedures.RohansCandleOpenGUIProcedure;
import mc.sayda.creraces.procedures.ScorpionChainOpenGUIProcedure;
import mc.sayda.creraces.world.inventory.DevilTearShopGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record DevilTearShopGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DevilTearShopGUIButtonMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("creraces", "devil_tear_shop_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DevilTearShopGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new DevilTearShopGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<DevilTearShopGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(DevilTearShopGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                DevilTearShopGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = DevilTearShopGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ScorpionChainOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            RohansCandleOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            DevilTearBuyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(TYPE, STREAM_CODEC, DevilTearShopGUIButtonMessage::handleData);
    }
}

