/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.HashMap;
import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.CROpenGoblinGUIProcedure;
import mc.sayda.creraces.procedures.HumanOpenGUIProcedure;
import mc.sayda.creraces.procedures.MakeHumanProcedure;
import mc.sayda.creraces.procedures.SecretNumpadAProcedure;
import mc.sayda.creraces.procedures.SecretNumpadBProcedure;
import mc.sayda.creraces.procedures.SecretNumpadDownProcedure;
import mc.sayda.creraces.procedures.SecretNumpadLeftProcedure;
import mc.sayda.creraces.procedures.SecretNumpadOkProcedure;
import mc.sayda.creraces.procedures.SecretNumpadRightProcedure;
import mc.sayda.creraces.procedures.SecretNumpadUpProcedure;
import mc.sayda.creraces.procedures.ToggleButtonPosProcedure;
import mc.sayda.creraces.world.inventory.HumanSelectorGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record HumanSelectorGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<HumanSelectorGUIButtonMessage> TYPE = new CustomPacketPayload.Type(new ResourceLocation("creraces", "human_selector_gui_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, HumanSelectorGUIButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new HumanSelectorGUIButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<HumanSelectorGUIButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(HumanSelectorGUIButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                HumanSelectorGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = HumanSelectorGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            CROpenGoblinGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            MakeHumanProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            HumanOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            ToggleButtonPosProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            CROpenGoblinGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            SecretNumpadUpProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            SecretNumpadRightProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            SecretNumpadLeftProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            SecretNumpadDownProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            SecretNumpadBProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            SecretNumpadAProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            SecretNumpadOkProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(TYPE, STREAM_CODEC, HumanSelectorGUIButtonMessage::handleData);
    }
}

