/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.item;

import java.util.List;
import mc.sayda.creraces.procedures.GoblinAllowProcedure;
import mc.sayda.creraces.procedures.GoblinHammerHitProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class GoblinHammerItem
extends AxeItem {
    public GoblinHammerItem() {
        super(new Tier(){

            public int getUses() {
                return 250;
            }

            public float getSpeed() {
                return 1.0f;
            }

            public float getAttackDamageBonus() {
                return -1.8f;
            }

            public int getLevel() {
                return 1;
            }

            public int getEnchantmentValue() {
                return 2;
            }

            public Ingredient getRepairIngredient() {
                return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.COBBLESTONE), new ItemStack((ItemLike)Blocks.COBBLED_DEEPSLATE)});
            }
        }, 1.0f, -3.0f, new Item.Properties());
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        GoblinHammerHitProcedure.execute((Entity)entity, (Entity)sourceentity);
        return retval;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        ItemStack retval = new ItemStack((ItemLike)this);
        retval.setDamageValue(itemstack.getDamageValue() + 1);
        if (retval.getDamageValue() >= retval.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        return retval;
    }

    public boolean isRepairable(ItemStack itemstack) {
        return false;
    }

    public void appendHoverText(ItemStack itemstack, Level level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, level, list, flag);
        list.add((Component)Component.literal((String)"\u00a7cGoblin Specific"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        GoblinAllowProcedure.execute(entity, itemstack);
    }
}

