/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.jei_recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RunicAltarCraftingRecipe
implements Recipe<SimpleContainer> {
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;

    public RunicAltarCraftingRecipe(ItemStack output, NonNullList<Ingredient> recipeItems) {
        this.output = output;
        this.recipeItems = recipeItems;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        return false;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess access) {
        return this.output;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return this.output.copy();
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Type
    implements RecipeType<RunicAltarCraftingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "runic_altar_crafting";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<RunicAltarCraftingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final Codec<RunicAltarCraftingRecipe> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] aingredient = (Ingredient[])ingredients.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients found in custom recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.recipeItems)).apply((Applicative)builder, RunicAltarCraftingRecipe::new));

        public Codec<RunicAltarCraftingRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public RunicAltarCraftingRecipe fromNetwork(FriendlyByteBuf buf) {
            NonNullList inputs = NonNullList.withSize((int)buf.readInt(), (Object)Ingredient.EMPTY);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buf));
            }
            return new RunicAltarCraftingRecipe(buf.readItem(), (NonNullList<Ingredient>)inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, RunicAltarCraftingRecipe recipe) {
            buf.writeInt(recipe.getIngredients().size());
            for (Ingredient ing : recipe.getIngredients()) {
                ing.toNetwork(buf);
            }
            buf.writeItem(recipe.getResultItem(null));
        }
    }
}

