/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.function.Supplier;
import mc.sayda.creraces.CreracesMod;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class CreracesModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"creraces");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(SavedDataSyncMessage.ID, SavedDataSyncMessage::new, SavedDataSyncMessage::handleData);
        CreracesMod.addNetworkMessage(PlayerVariablesSyncMessage.ID, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    public static class SavedDataSyncMessage
    implements CustomPacketPayload {
        public static final ResourceLocation ID = new ResourceLocation("creraces", "saved_data_sync");
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.type);
            if (this.data != null) {
                buffer.writeNbt((Tag)this.data.save(new CompoundTag()));
            }
        }

        public ResourceLocation id() {
            return ID;
        }

        public static void handleData(SavedDataSyncMessage message, PlayPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.workHandler().submitAsync(() -> {
                    if (message.type == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag()));
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag()));
                    }
                }).exceptionally(e -> {
                    context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = new ResourceLocation("creraces", "player_variables_sync");

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.readNbt());
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeNbt((Tag)this.data.serializeNBT());
        }

        public ResourceLocation id() {
            return ID;
        }

        public static void handleData(PlayerVariablesSyncMessage message, PlayPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.workHandler().submitAsync(() -> ((PlayerVariables)Minecraft.getInstance().player.getData(PLAYER_VARIABLES)).deserializeNBT(message.data.serializeNBT())).exceptionally(e -> {
                    context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean ButtonPos = false;
        public boolean ClassUpdate = false;
        public boolean guideGiven = false;
        public boolean HasChoosenRace = false;
        public boolean HasChoosenSubRace = false;
        public boolean HasPocket = false;
        public boolean HumanCheck = false;
        public boolean RaceUpdate = false;
        public boolean showSecretNumpad = false;
        public boolean AbilitySwitching = true;
        public boolean ShowCDOverlay = true;
        public boolean ShowRaceOverlay = true;
        public boolean Trail = true;
        public boolean UseHints = true;
        public double A1CD = 0.0;
        public double A2CD = 0.0;
        public double Grit = 0.0;
        public double InGUI = 0.0;
        public double IsRace2 = 0.0;
        public double ItemStacks = 0.0;
        public double Karma = 0.0;
        public double Mana = 0.0;
        public double numNumpad = 0.0;
        public double PCD = 0.0;
        public double RaceAbilityKeep = 0.0;
        public double RaceStyle = 0.0;
        public double TempValue1 = 0.0;
        public double TempValue2 = 0.0;
        public double TempValue3 = 0.0;
        public double TempValue4 = 0.0;
        public double TrailState = 0.0;
        public double WorldStatePlayer = 0.0;
        public double AD = 0.0;
        public double AH = 0.0;
        public double AP = 0.0;
        public double Coins = 0.0;
        public double CR = 0.0;
        public double dx = 0.0;
        public double dy = 0.0;
        public double dz = 0.0;
        public double Faction = 0.0;
        public double IsRace = 0.0;
        public double PassiveCooldown = 0.0;
        public double PassiveStacks = 0.0;
        public double px = 0.0;
        public double py = 0.0;
        public double pz = 0.0;
        public double RaceAbilityToggle = 0.0;
        public double RaceRanking = 0.0;
        public double Rage = 0.0;
        public double ResourceBar = 0.0;
        public double Skill1Level = 0.0;
        public double Skill2Level = 0.0;
        public double Skill3Level = 0.0;
        public double Skill4Level = 0.0;
        public double SkillPoints = 0.0;
        public double SkillSelect = 0.0;
        public double UltimateCooldown = 0.0;
        public double UltimateCooldown2 = 0.0;
        public double PocketSize = 1.0;
        public double Size = 1.0;
        public double Energy = 200.0;
        public double Soul = 9.0;
        public String RaceString = "None";
        public String raceTeam = "None";
        public double karmaState = 0.0;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("ButtonPos", this.ButtonPos);
            nbt.putBoolean("ClassUpdate", this.ClassUpdate);
            nbt.putBoolean("guideGiven", this.guideGiven);
            nbt.putBoolean("HasChoosenRace", this.HasChoosenRace);
            nbt.putBoolean("HasChoosenSubRace", this.HasChoosenSubRace);
            nbt.putBoolean("HasPocket", this.HasPocket);
            nbt.putBoolean("HumanCheck", this.HumanCheck);
            nbt.putBoolean("RaceUpdate", this.RaceUpdate);
            nbt.putBoolean("showSecretNumpad", this.showSecretNumpad);
            nbt.putBoolean("AbilitySwitching", this.AbilitySwitching);
            nbt.putBoolean("ShowCDOverlay", this.ShowCDOverlay);
            nbt.putBoolean("ShowRaceOverlay", this.ShowRaceOverlay);
            nbt.putBoolean("Trail", this.Trail);
            nbt.putBoolean("UseHints", this.UseHints);
            nbt.putDouble("A1CD", this.A1CD);
            nbt.putDouble("A2CD", this.A2CD);
            nbt.putDouble("Grit", this.Grit);
            nbt.putDouble("InGUI", this.InGUI);
            nbt.putDouble("IsRace2", this.IsRace2);
            nbt.putDouble("ItemStacks", this.ItemStacks);
            nbt.putDouble("Karma", this.Karma);
            nbt.putDouble("Mana", this.Mana);
            nbt.putDouble("numNumpad", this.numNumpad);
            nbt.putDouble("PCD", this.PCD);
            nbt.putDouble("RaceAbilityKeep", this.RaceAbilityKeep);
            nbt.putDouble("RaceStyle", this.RaceStyle);
            nbt.putDouble("TempValue1", this.TempValue1);
            nbt.putDouble("TempValue2", this.TempValue2);
            nbt.putDouble("TempValue3", this.TempValue3);
            nbt.putDouble("TempValue4", this.TempValue4);
            nbt.putDouble("TrailState", this.TrailState);
            nbt.putDouble("WorldStatePlayer", this.WorldStatePlayer);
            nbt.putDouble("AD", this.AD);
            nbt.putDouble("AH", this.AH);
            nbt.putDouble("AP", this.AP);
            nbt.putDouble("Coins", this.Coins);
            nbt.putDouble("CR", this.CR);
            nbt.putDouble("dx", this.dx);
            nbt.putDouble("dy", this.dy);
            nbt.putDouble("dz", this.dz);
            nbt.putDouble("Faction", this.Faction);
            nbt.putDouble("IsRace", this.IsRace);
            nbt.putDouble("PassiveCooldown", this.PassiveCooldown);
            nbt.putDouble("PassiveStacks", this.PassiveStacks);
            nbt.putDouble("px", this.px);
            nbt.putDouble("py", this.py);
            nbt.putDouble("pz", this.pz);
            nbt.putDouble("RaceAbilityToggle", this.RaceAbilityToggle);
            nbt.putDouble("RaceRanking", this.RaceRanking);
            nbt.putDouble("Rage", this.Rage);
            nbt.putDouble("ResourceBar", this.ResourceBar);
            nbt.putDouble("Skill1Level", this.Skill1Level);
            nbt.putDouble("Skill2Level", this.Skill2Level);
            nbt.putDouble("Skill3Level", this.Skill3Level);
            nbt.putDouble("Skill4Level", this.Skill4Level);
            nbt.putDouble("SkillPoints", this.SkillPoints);
            nbt.putDouble("SkillSelect", this.SkillSelect);
            nbt.putDouble("UltimateCooldown", this.UltimateCooldown);
            nbt.putDouble("UltimateCooldown2", this.UltimateCooldown2);
            nbt.putDouble("PocketSize", this.PocketSize);
            nbt.putDouble("Size", this.Size);
            nbt.putDouble("Energy", this.Energy);
            nbt.putDouble("Soul", this.Soul);
            nbt.putString("RaceString", this.RaceString);
            nbt.putString("raceTeam", this.raceTeam);
            nbt.putDouble("karmaState", this.karmaState);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.ButtonPos = nbt.getBoolean("ButtonPos");
            this.ClassUpdate = nbt.getBoolean("ClassUpdate");
            this.guideGiven = nbt.getBoolean("guideGiven");
            this.HasChoosenRace = nbt.getBoolean("HasChoosenRace");
            this.HasChoosenSubRace = nbt.getBoolean("HasChoosenSubRace");
            this.HasPocket = nbt.getBoolean("HasPocket");
            this.HumanCheck = nbt.getBoolean("HumanCheck");
            this.RaceUpdate = nbt.getBoolean("RaceUpdate");
            this.showSecretNumpad = nbt.getBoolean("showSecretNumpad");
            this.AbilitySwitching = nbt.getBoolean("AbilitySwitching");
            this.ShowCDOverlay = nbt.getBoolean("ShowCDOverlay");
            this.ShowRaceOverlay = nbt.getBoolean("ShowRaceOverlay");
            this.Trail = nbt.getBoolean("Trail");
            this.UseHints = nbt.getBoolean("UseHints");
            this.A1CD = nbt.getDouble("A1CD");
            this.A2CD = nbt.getDouble("A2CD");
            this.Grit = nbt.getDouble("Grit");
            this.InGUI = nbt.getDouble("InGUI");
            this.IsRace2 = nbt.getDouble("IsRace2");
            this.ItemStacks = nbt.getDouble("ItemStacks");
            this.Karma = nbt.getDouble("Karma");
            this.Mana = nbt.getDouble("Mana");
            this.numNumpad = nbt.getDouble("numNumpad");
            this.PCD = nbt.getDouble("PCD");
            this.RaceAbilityKeep = nbt.getDouble("RaceAbilityKeep");
            this.RaceStyle = nbt.getDouble("RaceStyle");
            this.TempValue1 = nbt.getDouble("TempValue1");
            this.TempValue2 = nbt.getDouble("TempValue2");
            this.TempValue3 = nbt.getDouble("TempValue3");
            this.TempValue4 = nbt.getDouble("TempValue4");
            this.TrailState = nbt.getDouble("TrailState");
            this.WorldStatePlayer = nbt.getDouble("WorldStatePlayer");
            this.AD = nbt.getDouble("AD");
            this.AH = nbt.getDouble("AH");
            this.AP = nbt.getDouble("AP");
            this.Coins = nbt.getDouble("Coins");
            this.CR = nbt.getDouble("CR");
            this.dx = nbt.getDouble("dx");
            this.dy = nbt.getDouble("dy");
            this.dz = nbt.getDouble("dz");
            this.Faction = nbt.getDouble("Faction");
            this.IsRace = nbt.getDouble("IsRace");
            this.PassiveCooldown = nbt.getDouble("PassiveCooldown");
            this.PassiveStacks = nbt.getDouble("PassiveStacks");
            this.px = nbt.getDouble("px");
            this.py = nbt.getDouble("py");
            this.pz = nbt.getDouble("pz");
            this.RaceAbilityToggle = nbt.getDouble("RaceAbilityToggle");
            this.RaceRanking = nbt.getDouble("RaceRanking");
            this.Rage = nbt.getDouble("Rage");
            this.ResourceBar = nbt.getDouble("ResourceBar");
            this.Skill1Level = nbt.getDouble("Skill1Level");
            this.Skill2Level = nbt.getDouble("Skill2Level");
            this.Skill3Level = nbt.getDouble("Skill3Level");
            this.Skill4Level = nbt.getDouble("Skill4Level");
            this.SkillPoints = nbt.getDouble("SkillPoints");
            this.SkillSelect = nbt.getDouble("SkillSelect");
            this.UltimateCooldown = nbt.getDouble("UltimateCooldown");
            this.UltimateCooldown2 = nbt.getDouble("UltimateCooldown2");
            this.PocketSize = nbt.getDouble("PocketSize");
            this.Size = nbt.getDouble("Size");
            this.Energy = nbt.getDouble("Energy");
            this.Soul = nbt.getDouble("Soul");
            this.RaceString = nbt.getString("RaceString");
            this.raceTeam = nbt.getString("raceTeam");
            this.karmaState = nbt.getDouble("karmaState");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{new PlayerVariablesSyncMessage(this)});
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "creraces_mapvars";
        public boolean UseCustomRaces = false;
        public boolean AllowA1 = true;
        public boolean AllowA2 = true;
        public double ratdenX = 0.0;
        public double ratdenY = 0.0;
        public double ratdenZ = 0.0;
        public double WorldState = 0.0;
        public double TotalGates = 0.0;
        public double TotalPockets = 1.0;
        public String RatKing = "None";
        public double runicCode = 0.0;
        public ListTag maskWarnings = new ListTag();
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            ListTag maskWarnings;
            this.UseCustomRaces = nbt.getBoolean("UseCustomRaces");
            this.AllowA1 = nbt.getBoolean("AllowA1");
            this.AllowA2 = nbt.getBoolean("AllowA2");
            this.ratdenX = nbt.getDouble("ratdenX");
            this.ratdenY = nbt.getDouble("ratdenY");
            this.ratdenZ = nbt.getDouble("ratdenZ");
            this.WorldState = nbt.getDouble("WorldState");
            this.TotalGates = nbt.getDouble("TotalGates");
            this.TotalPockets = nbt.getDouble("TotalPockets");
            this.RatKing = nbt.getString("RatKing");
            this.runicCode = nbt.getDouble("runicCode");
            Tag tag = nbt.get("maskWarnings");
            this.maskWarnings = tag instanceof ListTag ? (maskWarnings = (ListTag)tag) : new ListTag();
        }

        public CompoundTag save(CompoundTag nbt) {
            nbt.putBoolean("UseCustomRaces", this.UseCustomRaces);
            nbt.putBoolean("AllowA1", this.AllowA1);
            nbt.putBoolean("AllowA2", this.AllowA2);
            nbt.putDouble("ratdenX", this.ratdenX);
            nbt.putDouble("ratdenY", this.ratdenY);
            nbt.putDouble("ratdenZ", this.ratdenZ);
            nbt.putDouble("WorldState", this.WorldState);
            nbt.putDouble("TotalGates", this.TotalGates);
            nbt.putDouble("TotalPockets", this.TotalPockets);
            nbt.putString("RatKing", this.RatKing);
            nbt.putDouble("runicCode", this.runicCode);
            nbt.put("maskWarnings", (Tag)this.maskWarnings);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{new SavedDataSyncMessage(0, this)});
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "creraces_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag save(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.setDirty();
            if (world instanceof Level && !(level = (Level)world).isClientSide()) {
                PacketDistributor.DIMENSION.with((Object)level.dimension()).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, this)});
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.ButtonPos = original.ButtonPos;
            clone.ClassUpdate = original.ClassUpdate;
            clone.HasChoosenRace = original.HasChoosenRace;
            clone.HasChoosenSubRace = original.HasChoosenSubRace;
            clone.HasPocket = original.HasPocket;
            clone.HumanCheck = original.HumanCheck;
            clone.RaceUpdate = original.RaceUpdate;
            clone.AbilitySwitching = original.AbilitySwitching;
            clone.ShowCDOverlay = original.ShowCDOverlay;
            clone.ShowRaceOverlay = original.ShowRaceOverlay;
            clone.Trail = original.Trail;
            clone.UseHints = original.UseHints;
            clone.A1CD = original.A1CD;
            clone.A2CD = original.A2CD;
            clone.IsRace2 = original.IsRace2;
            clone.ItemStacks = original.ItemStacks;
            clone.Karma = original.Karma;
            clone.Mana = original.Mana;
            clone.PCD = original.PCD;
            clone.RaceAbilityKeep = original.RaceAbilityKeep;
            clone.RaceStyle = original.RaceStyle;
            clone.TrailState = original.TrailState;
            clone.AD = original.AD;
            clone.AH = original.AH;
            clone.AP = original.AP;
            clone.Coins = original.Coins;
            clone.CR = original.CR;
            clone.dx = original.dx;
            clone.dy = original.dy;
            clone.dz = original.dz;
            clone.Faction = original.Faction;
            clone.IsRace = original.IsRace;
            clone.PassiveStacks = original.PassiveStacks;
            clone.px = original.px;
            clone.py = original.py;
            clone.pz = original.pz;
            clone.RaceRanking = original.RaceRanking;
            clone.ResourceBar = original.ResourceBar;
            clone.Skill1Level = original.Skill1Level;
            clone.Skill2Level = original.Skill2Level;
            clone.Skill3Level = original.Skill3Level;
            clone.Skill4Level = original.Skill4Level;
            clone.SkillPoints = original.SkillPoints;
            clone.SkillSelect = original.SkillSelect;
            clone.PocketSize = original.PocketSize;
            clone.Size = original.Size;
            clone.Soul = original.Soul;
            clone.RaceString = original.RaceString;
            clone.raceTeam = original.raceTeam;
            clone.karmaState = original.karmaState;
            if (!event.isWasDeath()) {
                clone.guideGiven = original.guideGiven;
                clone.showSecretNumpad = original.showSecretNumpad;
                clone.Grit = original.Grit;
                clone.InGUI = original.InGUI;
                clone.numNumpad = original.numNumpad;
                clone.TempValue1 = original.TempValue1;
                clone.TempValue2 = original.TempValue2;
                clone.TempValue3 = original.TempValue3;
                clone.TempValue4 = original.TempValue4;
                clone.WorldStatePlayer = original.WorldStatePlayer;
                clone.PassiveCooldown = original.PassiveCooldown;
                clone.RaceAbilityToggle = original.RaceAbilityToggle;
                clone.Rage = original.Rage;
                clone.UltimateCooldown = original.UltimateCooldown;
                clone.UltimateCooldown2 = original.UltimateCooldown2;
                clone.Energy = original.Energy;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(0, mapdata)});
                }
                if (worlddata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, worlddata)});
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, worlddata)});
                }
            }
        }
    }
}

