/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.HashMap;
import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.MortarPestleUseProcedure;
import mc.sayda.creraces.world.inventory.MortarPestleGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record MortarPestleGUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("creraces", "mortar_pestle_gui_buttons");

    public MortarPestleGUIButtonMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.buttonID);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleData(MortarPestleGUIButtonMessage message, PlayPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.workHandler().submitAsync(() -> {
                Player entity = (Player)context.player().get();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                MortarPestleGUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = MortarPestleGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MortarPestleUseProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(ID, MortarPestleGUIButtonMessage::new, MortarPestleGUIButtonMessage::handleData);
    }
}

