/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import java.util.HashMap;
import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.MenuOpenGUIProcedure;
import mc.sayda.creraces.procedures.Race2OpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceDragonbornOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceDwarfOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceElementalistOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceFairyOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceGolemOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceHarpyOpenGuiProcedure;
import mc.sayda.creraces.procedures.RaceHumanOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceMermaidOpenGUIProcedure;
import mc.sayda.creraces.procedures.RaceUndeadOpenGUIProcedure;
import mc.sayda.creraces.world.inventory.Race1GUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record Race1GUIButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("creraces", "race_1_gui_buttons");

    public Race1GUIButtonMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.buttonID);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleData(Race1GUIButtonMessage message, PlayPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.workHandler().submitAsync(() -> {
                Player entity = (Player)context.player().get();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                Race1GUIButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = Race1GUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MenuOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            Race2OpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            RaceHumanOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            RaceUndeadOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 4) {
            RaceDwarfOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            RaceDragonbornOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 6) {
            RaceHarpyOpenGuiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 7) {
            RaceFairyOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 8) {
            RaceMermaidOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 9) {
            RaceElementalistOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            RaceGolemOpenGUIProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(ID, Race1GUIButtonMessage::new, Race1GUIButtonMessage::handleData);
    }
}

