/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.network;

import mc.sayda.creraces.CreracesMod;
import mc.sayda.creraces.procedures.SwapSkillsProcedure;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record SwapMessage(int type, int pressedms) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("creraces", "key_swap");

    public SwapMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.type);
        buffer.writeInt(this.pressedms);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handleData(SwapMessage message, PlayPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.workHandler().submitAsync(() -> SwapMessage.pressAction((Player)context.player().get(), message.type, message.pressedms)).exceptionally(e -> {
                context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            SwapSkillsProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CreracesMod.addNetworkMessage(ID, SwapMessage::new, SwapMessage::handleData);
    }
}

