/*
 * Decompiled with CFR 0.152.
 */
package mc.sayda.creraces.world.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mc.sayda.creraces.init.CreracesModMenus;
import mc.sayda.creraces.network.ItemStorageGUISlotMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

public class ItemStorageGUIMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;

    public ItemStorageGUIMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)CreracesModMenus.ITEM_STORAGE_GUI.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(6);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                this.boundItemMatcher = () -> itemstack == (hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem());
                IItemHandler cap = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
                if (cap != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                IItemHandler cap;
                extraData.readByte();
                this.boundEntity = this.world.getEntity(extraData.readVarInt());
                if (this.boundEntity != null && (cap = (IItemHandler)this.boundEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else {
                this.boundBlockEntity = this.world.getBlockEntity(pos);
                itemstack = this.boundBlockEntity;
                if (itemstack instanceof BaseContainerBlockEntity) {
                    BaseContainerBlockEntity baseContainerBlockEntity = (BaseContainerBlockEntity)itemstack;
                    this.internal = new InvWrapper((Container)baseContainerBlockEntity);
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this.internal, 0, 16, 23){

            public void setChanged() {
                super.setChanged();
                ItemStorageGUIMenu.this.slotChanged(0, 0, 0);
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this.internal, 1, 52, 23){

            public void setChanged() {
                super.setChanged();
                ItemStorageGUIMenu.this.slotChanged(1, 0, 0);
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this.internal, 2, 88, 23){

            public void setChanged() {
                super.setChanged();
                ItemStorageGUIMenu.this.slotChanged(2, 0, 0);
            }
        }));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this.internal, 3, 16, 50){

            public void setChanged() {
                super.setChanged();
                ItemStorageGUIMenu.this.slotChanged(3, 0, 0);
            }
        }));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this.internal, 4, 52, 50){

            public void setChanged() {
                super.setChanged();
                ItemStorageGUIMenu.this.slotChanged(4, 0, 0);
            }
        }));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this.internal, 5, 88, 50){

            public void setChanged() {
                super.setChanged();
                ItemStorageGUIMenu.this.slotChanged(5, 0, 0);
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 6) {
                if (!this.moveItemStackTo(itemstack1, 6, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 6, false)) {
                if (index < 33 ? !this.moveItemStackTo(itemstack1, 33, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 6, 33, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameTags((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(), p_38904_.getMaxStackSize()))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        p_38904_.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    if (p_38904_.getCount() > slot1.getMaxStackSize()) {
                        slot1.setByPlayer(p_38904_.split(slot1.getMaxStackSize()));
                    } else {
                        slot1.setByPlayer(p_38904_.split(p_38904_.getCount()));
                    }
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    if (j == 0 || j == 1 || j == 2 || j == 3 || j == 4 || j == 5) continue;
                    playerIn.drop(this.internal.getStackInSlot(j), false);
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof IItemHandlerModifiable)) continue;
                    IItemHandlerModifiable ihm = (IItemHandlerModifiable)iItemHandler;
                    ihm.setStackInSlot(j, ItemStack.EMPTY);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    if (i == 0 || i == 1 || i == 2 || i == 3 || i == 4 || i == 5) continue;
                    playerIn.getInventory().placeItemBackInInventory(this.internal.getStackInSlot(i));
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof IItemHandlerModifiable)) continue;
                    IItemHandlerModifiable ihm = (IItemHandlerModifiable)iItemHandler;
                    ihm.setStackInSlot(i, ItemStack.EMPTY);
                }
            }
        }
    }

    private void slotChanged(int slotid, int ctype, int meta) {
        if (this.world != null && this.world.isClientSide()) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ItemStorageGUISlotMessage(slotid, this.x, this.y, this.z, ctype, meta)});
            ItemStorageGUISlotMessage.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

