/*
 * Decompiled with CFR 0.152.
 */
package pokelucky;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pokelucky.Data;
import pokelucky.Main;
import pokelucky.Process;

public class Characters {
    protected static void registerCharacters() {
        int randomId = 1;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pokelucky", "musashi"), Musashi.class, (String)"musashi", (int)randomId++, (Object)Main.instance, (int)60, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pokelucky", "kojiro"), Kojiro.class, (String)"kojiro", (int)randomId++, (Object)Main.instance, (int)60, (int)3, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("pokelucky", "monsterchest"), MonsterBox.class, (String)"monsterchest", (int)randomId++, (Object)Main.instance, (int)60, (int)3, (boolean)true);
        ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("pokelucky", "musashi"))).setEgg(new EntityList.EntityEggInfo(new ResourceLocation("pokelucky", "musashi"), 0xFFDDDD, 0xFF0000));
        ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("pokelucky", "kojiro"))).setEgg(new EntityList.EntityEggInfo(new ResourceLocation("pokelucky", "kojiro"), 0xDDDDFF, 255));
        ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("pokelucky", "monsterchest"))).setEgg(new EntityList.EntityEggInfo(new ResourceLocation("pokelucky", "monsterchest"), 16756224, 0));
    }

    protected static class MonsterBox
    extends EntityLiving
    implements IMob {
        private static final DataParameter<Integer> SLIME_SIZE = EntityDataManager.func_187226_a(MonsterBox.class, (DataSerializer)DataSerializers.field_187192_b);
        public float squishAmount;
        public float squishFactor;
        public float prevSquishFactor;
        private boolean wasOnGround;

        public MonsterBox(World worldIn) {
            super(worldIn);
            this.field_70765_h = new SlimeMoveHelper(this);
        }

        protected void func_184651_r() {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AISlimeFloat(this));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISlimeAttack(this));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISlimeFaceRandom(this));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AISlimeHop(this));
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearest((EntityLiving)this, EntityIronGolem.class));
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(SLIME_SIZE, (Object)1);
        }

        public void setSlimeSize(int size, boolean resetHealth) {
            this.field_70180_af.func_187227_b(SLIME_SIZE, (Object)size);
            this.func_70105_a(0.51000005f * (float)size, 0.51000005f * (float)size);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(size * size));
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)(0.2f + 0.1f * (float)size));
            if (resetHealth) {
                this.func_70606_j(this.func_110138_aP());
            }
            this.field_70728_aV = size;
        }

        public int getSlimeSize() {
            return (Integer)this.field_70180_af.func_187225_a(SLIME_SIZE);
        }

        public static void registerFixesSlime(DataFixer fixer) {
            EntityLiving.func_189752_a((DataFixer)fixer, MonsterBox.class);
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74768_a("Size", this.getSlimeSize() - 1);
            compound.func_74757_a("wasOnGround", this.wasOnGround);
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            int i = compound.func_74762_e("Size");
            if (i < 0) {
                i = 0;
            }
            this.setSlimeSize(i + 1, false);
            this.wasOnGround = compound.func_74767_n("wasOnGround");
        }

        public boolean isSmallSlime() {
            return this.getSlimeSize() <= 1;
        }

        protected EnumParticleTypes getParticleType() {
            return EnumParticleTypes.SNOW_SHOVEL;
        }

        public void func_70071_h_() {
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.getSlimeSize() > 0) {
                this.field_70128_L = true;
            }
            this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
            this.prevSquishFactor = this.squishFactor;
            super.func_70071_h_();
            if (this.field_70122_E && !this.wasOnGround) {
                int i = this.getSlimeSize();
                if (this.spawnCustomParticles()) {
                    i = 0;
                }
                for (int j = 0; j < i * 8; ++j) {
                    float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
                    float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
                    float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
                    World world = this.field_70170_p;
                    EnumParticleTypes enumparticletypes = this.getParticleType();
                    double d0 = this.field_70165_t + (double)f2;
                    double d1 = this.field_70161_v + (double)f3;
                    world.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[0]);
                }
                this.func_184185_a(this.getSquishSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
                this.squishAmount = -0.5f;
            } else if (!this.field_70122_E && this.wasOnGround) {
                this.squishAmount = 1.0f;
            }
            this.wasOnGround = this.field_70122_E;
            this.alterSquishAmount();
        }

        protected void alterSquishAmount() {
            this.squishAmount *= 0.6f;
        }

        protected int getJumpDelay() {
            return this.field_70146_Z.nextInt(20) + 10;
        }

        protected MonsterBox createInstance() {
            return new MonsterBox(this.field_70170_p);
        }

        public void func_184206_a(DataParameter<?> key) {
            if (SLIME_SIZE.equals(key)) {
                int i = this.getSlimeSize();
                this.func_70105_a(0.51000005f * (float)i, 0.51000005f * (float)i);
                this.field_70177_z = this.field_70759_as;
                this.field_70761_aq = this.field_70759_as;
                if (this.func_70090_H() && this.field_70146_Z.nextInt(20) == 0) {
                    this.func_71061_d_();
                }
            }
            super.func_184206_a(key);
        }

        public void func_70106_y() {
            super.func_70106_y();
        }

        public void func_70108_f(Entity entityIn) {
            super.func_70108_f(entityIn);
            if (entityIn instanceof EntityIronGolem && this.canDamagePlayer()) {
                this.dealDamage((EntityLivingBase)entityIn);
            }
        }

        public void func_70100_b_(EntityPlayer entityIn) {
            if (this.canDamagePlayer()) {
                this.dealDamage((EntityLivingBase)entityIn);
            }
        }

        protected void dealDamage(EntityLivingBase entityIn) {
            int i = this.getSlimeSize();
            if (this.func_70685_l((Entity)entityIn) && this.func_70068_e((Entity)entityIn) < 0.6 * (double)i * 0.6 * (double)i && entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.getAttackStrength())) {
                this.func_184185_a(SoundEvents.field_187603_D, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.func_174815_a((EntityLivingBase)this, (Entity)entityIn);
            }
        }

        public float func_70047_e() {
            return 0.625f * this.field_70131_O;
        }

        protected boolean canDamagePlayer() {
            return !this.isSmallSlime();
        }

        protected int getAttackStrength() {
            return this.getSlimeSize();
        }

        protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
            return this.isSmallSlime() ? SoundEvents.field_187603_D : SoundEvents.field_187603_D;
        }

        protected SoundEvent func_184615_bR() {
            return this.isSmallSlime() ? SoundEvents.field_187692_g : SoundEvents.field_187692_g;
        }

        protected SoundEvent getSquishSound() {
            return this.isSmallSlime() ? SoundEvents.field_187881_gQ : SoundEvents.field_187881_gQ;
        }

        protected Item func_146068_u() {
            return null;
        }

        @Nullable
        protected ResourceLocation func_184647_J() {
            return this.getSlimeSize() == 1 ? LootTableList.field_186419_a : LootTableList.field_186419_a;
        }

        public boolean func_70601_bi() {
            BlockPos blockpos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
            Chunk chunk = this.field_70170_p.func_175726_f(blockpos);
            if (this.field_70170_p.func_72912_H().func_76067_t().handleSlimeSpawnReduction(this.field_70146_Z, this.field_70170_p)) {
                return false;
            }
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                Biome biome = this.field_70170_p.func_180494_b(blockpos);
                if (biome == Biomes.field_76780_h && this.field_70163_u > 50.0 && this.field_70163_u < 70.0 && this.field_70146_Z.nextFloat() < 0.5f && this.field_70146_Z.nextFloat() < this.field_70170_p.func_130001_d() && this.field_70170_p.func_175671_l(new BlockPos((Entity)this)) <= this.field_70146_Z.nextInt(8)) {
                    return super.func_70601_bi();
                }
                if (this.field_70146_Z.nextInt(10) == 0 && chunk.func_76617_a(987234911L).nextInt(10) == 0 && this.field_70163_u < 40.0) {
                    return super.func_70601_bi();
                }
            }
            return false;
        }

        protected float func_70599_aP() {
            return 0.4f * (float)this.getSlimeSize();
        }

        public int func_70646_bf() {
            return 0;
        }

        protected boolean makesSoundOnJump() {
            return this.getSlimeSize() > 0;
        }

        protected void func_70664_aZ() {
            this.field_70181_x = 0.42f;
            this.field_70160_al = true;
        }

        @Nullable
        public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
            this.setSlimeSize(2, true);
            return super.func_180482_a(difficulty, livingdata);
        }

        protected SoundEvent getJumpSound() {
            return this.isSmallSlime() ? SoundEvents.field_187881_gQ : SoundEvents.field_187881_gQ;
        }

        protected boolean spawnCustomParticles() {
            return false;
        }

        static class SlimeMoveHelper
        extends EntityMoveHelper {
            private float yRot;
            private int jumpDelay;
            private final MonsterBox slime;
            private boolean isAggressive;

            public SlimeMoveHelper(MonsterBox slimeIn) {
                super((EntityLiving)slimeIn);
                this.slime = slimeIn;
                this.yRot = 180.0f * slimeIn.field_70177_z / (float)Math.PI;
            }

            public void setDirection(float p_179920_1_, boolean p_179920_2_) {
                this.yRot = p_179920_1_;
                this.isAggressive = p_179920_2_;
            }

            public void setSpeed(double speedIn) {
                this.field_75645_e = speedIn;
                this.field_188491_h = EntityMoveHelper.Action.MOVE_TO;
            }

            public void func_75641_c() {
                this.field_75648_a.field_70759_as = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, this.yRot, 90.0f);
                this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z;
                if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    if (this.field_75648_a.field_70122_E) {
                        this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                        if (this.jumpDelay-- <= 0) {
                            this.jumpDelay = this.slime.getJumpDelay();
                            if (this.isAggressive) {
                                this.jumpDelay /= 3;
                            }
                            this.slime.func_70683_ar().func_75660_a();
                            if (this.slime.makesSoundOnJump()) {
                                this.slime.func_184185_a(this.slime.getJumpSound(), this.slime.func_70599_aP(), ((this.slime.func_70681_au().nextFloat() - this.slime.func_70681_au().nextFloat()) * 0.2f + 1.0f) * 0.8f);
                            }
                        } else {
                            this.slime.field_70702_br = 0.0f;
                            this.slime.field_191988_bg = 0.0f;
                            this.field_75648_a.func_70659_e(0.0f);
                        }
                    } else {
                        this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    }
                }
            }
        }

        static class AISlimeHop
        extends EntityAIBase {
            private final MonsterBox slime;

            public AISlimeHop(MonsterBox slimeIn) {
                this.slime = slimeIn;
                this.func_75248_a(5);
            }

            public boolean func_75250_a() {
                return true;
            }

            public void func_75246_d() {
                ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.0);
            }
        }

        static class AISlimeFloat
        extends EntityAIBase {
            private final MonsterBox slime;

            public AISlimeFloat(MonsterBox slimeIn) {
                this.slime = slimeIn;
                this.func_75248_a(5);
                ((PathNavigateGround)slimeIn.func_70661_as()).func_179693_d(true);
            }

            public boolean func_75250_a() {
                return this.slime.func_70090_H() || this.slime.func_180799_ab();
            }

            public void func_75246_d() {
                if (this.slime.func_70681_au().nextFloat() < 0.8f) {
                    this.slime.func_70683_ar().func_75660_a();
                }
                ((SlimeMoveHelper)this.slime.func_70605_aq()).setSpeed(1.2);
            }
        }

        static class AISlimeFaceRandom
        extends EntityAIBase {
            private final MonsterBox slime;
            private float chosenDegrees;
            private int nextRandomizeTime;

            public AISlimeFaceRandom(MonsterBox slimeIn) {
                this.slime = slimeIn;
                this.func_75248_a(2);
            }

            public boolean func_75250_a() {
                return this.slime.func_70638_az() == null && (this.slime.field_70122_E || this.slime.func_70090_H() || this.slime.func_180799_ab() || this.slime.func_70644_a(MobEffects.field_188424_y));
            }

            public void func_75246_d() {
                if (--this.nextRandomizeTime <= 0) {
                    this.nextRandomizeTime = 40 + this.slime.func_70681_au().nextInt(60);
                    this.chosenDegrees = this.slime.func_70681_au().nextInt(360);
                }
                ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.chosenDegrees, false);
            }
        }

        static class AISlimeAttack
        extends EntityAIBase {
            private final MonsterBox slime;
            private int growTieredTimer;

            public AISlimeAttack(MonsterBox slimeIn) {
                this.slime = slimeIn;
                this.func_75248_a(2);
            }

            public boolean func_75250_a() {
                EntityLivingBase entitylivingbase = this.slime.func_70638_az();
                if (entitylivingbase == null) {
                    return false;
                }
                if (!entitylivingbase.func_70089_S()) {
                    return false;
                }
                return !(entitylivingbase instanceof EntityPlayer) || !((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a;
            }

            public void func_75249_e() {
                this.growTieredTimer = 300;
                super.func_75249_e();
            }

            public boolean func_75253_b() {
                EntityLivingBase entitylivingbase = this.slime.func_70638_az();
                if (entitylivingbase == null) {
                    return false;
                }
                if (!entitylivingbase.func_70089_S()) {
                    return false;
                }
                if (entitylivingbase instanceof EntityPlayer && ((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) {
                    return false;
                }
                return --this.growTieredTimer > 0;
            }

            public void func_75246_d() {
                this.slime.func_70625_a((Entity)this.slime.func_70638_az(), 10.0f, 10.0f);
                ((SlimeMoveHelper)this.slime.func_70605_aq()).setDirection(this.slime.field_70177_z, this.slime.canDamagePlayer());
            }
        }
    }

    protected static class Kojiro
    extends EntityMob {
        private Object[] pokemon;

        public Kojiro(World world) {
            super(world);
            this.func_70606_j(5.5f);
            if (Data.pokeElement == Data.PixelmonElement.reforged) {
                this.pokemon = Process.reforged.pokemonList();
            } else if (Data.pokeElement == Data.PixelmonElement.generations) {
                this.pokemon = Process.generations.pokemonList();
            }
        }

        protected void func_184651_r() {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        }

        public NBTTagCompound func_189511_e(NBTTagCompound compound) {
            super.func_189511_e(compound);
            if (Data.pokeElement == Data.PixelmonElement.reforged) {
                Process.reforged.writeKojiro(this.pokemon, compound);
            } else if (Data.pokeElement == Data.PixelmonElement.generations) {
                Process.generations.writeKojiro(this.pokemon, compound);
            }
            return compound;
        }

        public void func_70020_e(NBTTagCompound compound) {
            super.func_70020_e(compound);
            if (Data.pokeElement == Data.PixelmonElement.reforged) {
                Process.reforged.readKojiro(this.pokemon, compound);
            } else if (Data.pokeElement == Data.PixelmonElement.generations) {
                Process.generations.readKojiro(this.pokemon, compound);
            }
        }

        public void pokeAdd(Object pokemon2, int index) {
            this.pokemon[index] = pokemon2;
        }

        public Object[] getStore() {
            return this.pokemon;
        }
    }

    protected static class Musashi
    extends EntityMob {
        private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);

        public Musashi(World worldIn) {
            super(worldIn);
            this.func_70606_j(5.5f);
        }

        protected void func_184651_r() {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
            this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        }

        public NBTTagCompound func_189511_e(NBTTagCompound compound) {
            super.func_189511_e(compound);
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
            return compound;
        }

        public void func_70020_e(NBTTagCompound compound) {
            super.func_70020_e(compound);
            this.inventory = NonNullList.func_191197_a((int)this.inventory.size(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        }

        public boolean isFull() {
            int num = 0;
            for (int i = 0; i < this.inventory.size() && !((ItemStack)this.inventory.get(i)).func_190926_b(); ++i) {
                ++num;
            }
            return num >= 5;
        }

        public void getAdd(ItemStack item) {
            if (!this.isFull()) {
                for (int i = 0; i < this.inventory.size(); ++i) {
                    if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                    this.inventory.set(i, (Object)new ItemStack(item.func_77973_b(), item.func_190916_E()));
                    break;
                }
            }
        }

        public void func_70645_a(DamageSource cause) {
            super.func_70645_a(cause);
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
                this.func_70099_a((ItemStack)this.inventory.get(i), 0.0f);
            }
        }
    }
}

