/*
 * Decompiled with CFR 0.152.
 */
package pokelucky;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import pokelucky.Characters;
import pokelucky.Commands;
import pokelucky.Data;
import pokelucky.Display;
import pokelucky.Network;
import pokelucky.Objects;
import pokelucky.Process;

@Mod(modid="pokelucky", name="Pokelucky", version="6.14.9")
public class Main {
    protected static final String MODID = "pokelucky";
    protected static final String NAME = "Pokelucky";
    protected static final String VERSION = "6.14.9";
    @Mod.Instance(value="pokelucky")
    protected static Main instance;

    @Mod.EventHandler
    protected void preInit(FMLPreInitializationEvent event) {
        Network.register();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new Display.UI.Screen());
        Characters.registerCharacters();
    }

    @Mod.EventHandler
    protected void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new Process());
        CapabilityManager.INSTANCE.register(Data.Server.IStatus.class, (Capability.IStorage)new Data.Server.Player.Storage(), Data.Server.Player.class);
        Process.crafting();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        Commands.register(event);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent event) {
        WorldServer world;
        Data.pokeElement = Process.pixelmonCase();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (world = server.func_71218_a(0)) != null) {
            Process.startServer(world);
        }
    }

    @Mod.EventBusSubscriber
    protected static class RegsitrationHandler {
        protected RegsitrationHandler() {
        }

        @SubscribeEvent
        protected static void registerBlocks(RegistryEvent.Register<Block> event) {
            Objects.registerBlock((IForgeRegistry<Block>)event.getRegistry());
        }

        @SubscribeEvent
        protected static void registerItems(RegistryEvent.Register<Item> event) {
            Objects.registerItem((IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent
        protected static void registerModels(ModelRegistryEvent event) {
            Display.Renders.Object();
            Display.Renders.Character();
        }
    }
}

