/*
 * Decompiled with CFR 0.152.
 */
package pokelucky;

import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class Data {

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        @CapabilityInject(value=Server.IWallet.class)
        public static final Capability<Server.IWallet> Wallet_CAP = null;
        private Server.IWallet instance = (Server.IWallet)Wallet_CAP.getDefaultInstance();
        private final LazyOptional<Server.IWallet> optional = LazyOptional.of(() -> this.instance);

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == Wallet_CAP ? this.optional.cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return Wallet_CAP.getStorage().writeNBT(Wallet_CAP, (Object)this.instance, null);
        }

        public void deserializeNBT(INBT nbt) {
            Wallet_CAP.getStorage().readNBT(Wallet_CAP, (Object)this.instance, null, nbt);
        }
    }

    protected static class Client {
        protected Client() {
        }

        @OnlyIn(value=Dist.CLIENT)
        protected static class Player {
            protected static int bank = 0;
            protected static int wallet = 0;

            protected Player() {
            }

            protected static int getWallet() {
                return wallet;
            }

            protected static void setWallet(int money) {
                wallet = money;
            }

            protected static int getBank() {
                return bank;
            }

            protected static void setBank(int money) {
                bank = money;
            }
        }

        protected static class World {
            protected static int pre_pokemon;
            protected static int pre_mob;
            protected static int pre_rocket;
            protected static int pre_chest;
            protected static int pre_legend;
            protected static int pre_beast;
            protected static int pre_monschest;

            protected World() {
            }

            protected static EnderChestInventory getRandomeItems(ServerWorld world) {
                EnderChestInventory enderChestInventory = new EnderChestInventory();
                enderChestInventory.func_70486_a(Server.World.forWorld(world).getData().func_150295_c("randomChestInventory", 10));
                return enderChestInventory;
            }
        }
    }

    protected static class Server {
        protected Server() {
        }

        public static interface IWallet {
            public int getBank();

            public void setBank(int var1);
        }

        public static class Player
        implements IWallet {
            private int bank = 0;

            @Override
            public void setBank(int points) {
                this.bank = points;
            }

            @Override
            public int getBank() {
                return this.bank;
            }

            public static class Storage
            implements Capability.IStorage<IWallet> {
                public INBT writeNBT(Capability<IWallet> capability, IWallet instance, Direction side) {
                    CompoundNBT status = new CompoundNBT();
                    status.func_74768_a("Bank", instance.getBank());
                    return status;
                }

                public void readNBT(Capability<IWallet> capability, IWallet instance, Direction side, INBT nbt) {
                    CompoundNBT status = (CompoundNBT)nbt;
                    instance.setBank(status.func_74762_e("Bank"));
                }
            }

            protected static class Bank {
                protected Bank() {
                }

                protected static int getBank(ServerPlayerEntity player) {
                    return player.getCapability(Provider.Wallet_CAP, null).map(IWallet::getBank).orElse(0);
                }

                protected static void setBank(ServerPlayerEntity player, int money) {
                    player.getCapability(Provider.Wallet_CAP, null).ifPresent(status -> status.setBank(money));
                }
            }
        }

        protected static class World
        extends WorldSavedData {
            private CompoundNBT data = new CompoundNBT();

            public World() {
                super("pokelucky");
            }

            public static World forWorld(ServerWorld world) {
                DimensionSavedDataManager storage = world.func_217481_x();
                World result = (World)storage.func_215752_a(World::new, "pokelucky");
                if (result == null) {
                    result = new World();
                    storage.func_215757_a((WorldSavedData)result);
                }
                return result;
            }

            public void func_76184_a(CompoundNBT compound) {
                this.data = compound.func_74775_l("pokelucky");
            }

            public CompoundNBT func_189551_b(CompoundNBT compound) {
                compound.func_218657_a("pokelucky", (INBT)this.data);
                return compound;
            }

            public CompoundNBT getData() {
                return this.data;
            }

            public void setData(CompoundNBT data) {
                this.data = data;
            }

            protected static void setFirst(ServerWorld world, boolean pre) {
                World.forWorld(world).getData().func_74757_a("isFirst", pre);
                World.forWorld(world).func_76185_a();
            }

            protected static boolean getFirst(ServerWorld world) {
                return World.forWorld(world).getData().func_74767_n("isFirst");
            }

            protected static void setPrePokemon(ServerWorld world, int pre) {
                World.forWorld(world).getData().func_74768_a("pre_pokemon", pre);
                World.forWorld(world).func_76185_a();
            }

            protected static int getPrePokemon(ServerWorld world) {
                return World.forWorld(world).getData().func_74762_e("pre_pokemon");
            }

            protected static void setPreMob(ServerWorld world, int pre) {
                World.forWorld(world).getData().func_74768_a("pre_mob", pre);
                World.forWorld(world).func_76185_a();
            }

            protected static int getPreMob(ServerWorld world) {
                return World.forWorld(world).getData().func_74762_e("pre_mob");
            }

            protected static void setPreRocket(ServerWorld world, int pre) {
                World.forWorld(world).getData().func_74768_a("pre_rocket", pre);
                World.forWorld(world).func_76185_a();
            }

            protected static int getPreRocket(ServerWorld world) {
                return World.forWorld(world).getData().func_74762_e("pre_rocket");
            }

            protected static void setPreChest(ServerWorld world, int pre) {
                World.forWorld(world).getData().func_74768_a("pre_chest", pre);
                World.forWorld(world).func_76185_a();
            }

            protected static int getPreChest(ServerWorld world) {
                return World.forWorld(world).getData().func_74762_e("pre_chest");
            }

            protected static void setPreLegend(ServerWorld world, int pre) {
                World.forWorld(world).getData().func_74768_a("pre_legend", pre);
                World.forWorld(world).func_76185_a();
            }

            protected static int getPreLegend(ServerWorld world) {
                return World.forWorld(world).getData().func_74762_e("pre_legend");
            }

            protected static void setPreBeast(ServerWorld world, int pre) {
                World.forWorld(world).getData().func_74768_a("pre_beast", pre);
                World.forWorld(world).func_76185_a();
            }

            protected static int getPreBeast(ServerWorld world) {
                return World.forWorld(world).getData().func_74762_e("pre_beast");
            }

            protected static void setPreMonschest(ServerWorld world, int pre) {
                World.forWorld(world).getData().func_74768_a("pre_monschest", pre);
                World.forWorld(world).func_76185_a();
            }

            protected static int getPreMonschest(ServerWorld world) {
                return World.forWorld(world).getData().func_74762_e("pre_monschest");
            }

            protected static void setRandomeItems(ServerWorld world, ListNBT enderChestInventory) {
                World.forWorld(world).getData().func_218657_a("randomChestInventory", (INBT)enderChestInventory);
                World.forWorld(world).func_76185_a();
            }

            protected static EnderChestInventory getRandomeItems(ServerWorld world) {
                EnderChestInventory enderChestInventory = new EnderChestInventory();
                enderChestInventory.func_70486_a(World.forWorld(world).getData().func_150295_c("randomChestInventory", 10));
                return enderChestInventory;
            }
        }
    }
}

