/*
 * Decompiled with CFR 0.152.
 */
package pokelucky;

import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.tileentity.ChestTileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import pokelucky.Characters;
import pokelucky.Commands;
import pokelucky.Data;
import pokelucky.Display;
import pokelucky.Network;
import pokelucky.Objects;
import pokelucky.Process;

@Mod(value="pokelucky")
public class Main {
    public static final String MODID = "pokelucky";

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new Process());
        MinecraftForge.EVENT_BUS.register((Object)new RegistryEvents.EventRegistrys());
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(Data.Server.IWallet.class, (Capability.IStorage)new Data.Server.Player.Storage(), Data.Server.Player::new);
        Network.registers();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(Characters.musashi, Display.Character.RenderMusashi::new);
        RenderingRegistry.registerEntityRenderingHandler(Characters.kojiro, Display.Character.RenderKojiro::new);
        RenderingRegistry.registerEntityRenderingHandler(Characters.monster, Display.Character.RenderMonster::new);
        ScreenManager.func_216911_a(Process.UI.RandomChestContainer, Display.UI.Screens.RandomChestGuiScreen::new);
        ClientRegistry.bindTileEntityRenderer(Objects.TileEntitys.MonsterBlock, ChestTileEntityRenderer::new);
        MinecraftForge.EVENT_BUS.register((Object)new Process.Client());
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        ServerWorld world;
        MinecraftServer server = event.getServer();
        if (server != null && (world = server.func_241755_D_()) != null) {
            Process.startServer(world);
        }
    }

    @Mod.EventBusSubscriber(modid="pokelucky", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
            Objects.registerBlocks(event);
        }

        @SubscribeEvent
        public static void onRegisterItems(RegistryEvent.Register<Item> event) {
            Objects.registerItems(event);
        }

        @SubscribeEvent
        public static void registerTileEntitys(RegistryEvent.Register<TileEntityType<?>> event) {
            Objects.registerTileEntitys(event);
        }

        @SubscribeEvent
        public static void registerMenuTypes(RegistryEvent.Register<ContainerType<?>> registryEvent) {
            Process.UI.registerMenuTypes(registryEvent);
        }

        static class EventRegistrys {
            EventRegistrys() {
            }

            @SubscribeEvent
            public void commandsRegister(RegisterCommandsEvent event) {
                Commands.register(event);
            }

            @SubscribeEvent
            public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
                event.addCapability(new ResourceLocation(Main.MODID, "wallet"), (ICapabilityProvider)new Data.Provider());
            }
        }
    }
}

