/*
 * Decompiled with CFR 0.152.
 */
package pokelucky;

import com.mojang.datafixers.DSL;
import java.io.Serializable;
import java.util.function.BiConsumer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pokelucky.Characters;
import pokelucky.Display;
import pokelucky.Process;

public class Objects {
    public static void registerBlocks(RegistryEvent.Register<Block> registry) {
        registry.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{Blocks.blockrandmon, Blocks.blockbackcase, Blocks.blockbattery, Blocks.blockcircuits, Blocks.blockfrontcase, Blocks.blockmonitor, Blocks.monsterbox, Blocks.legendrand, Blocks.beastrand});
    }

    public static void registerItems(RegistryEvent.Register<Item> registry) {
        registry.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockNamedItem(Blocks.blockrandmon, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(Blocks.blockrandmon.getRegistryName()), (Item)new BlockNamedItem(Blocks.blockbackcase, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(Blocks.blockbackcase.getRegistryName()), (Item)new BlockNamedItem(Blocks.blockbattery, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(Blocks.blockbattery.getRegistryName()), (Item)new BlockNamedItem(Blocks.blockcircuits, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(Blocks.blockcircuits.getRegistryName()), (Item)new BlockNamedItem(Blocks.blockfrontcase, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(Blocks.blockfrontcase.getRegistryName()), (Item)new BlockNamedItem(Blocks.blockmonitor, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(Blocks.blockmonitor.getRegistryName()), (Item)new BlockNamedItem(Blocks.legendrand, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(Blocks.legendrand.getRegistryName()), (Item)new BlockNamedItem(Blocks.beastrand, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(Blocks.beastrand.getRegistryName()), Items.pokephone, Items.back_case, Items.battery, Items.circuits, Items.front_case, Items.monitor, Items.spawn_kojiro, Items.spawn_musashi, Items.spawn_moster});
    }

    public static void registerTileEntitys(RegistryEvent.Register<TileEntityType<?>> registryEvent) {
        TileEntitys.MonsterBlock = TileEntityType.Builder.func_223042_a(TileMonsterBlock::new, (Block[])new Block[]{Blocks.monsterbox}).func_206865_a(Util.func_240976_a_((DSL.TypeReference)TypeReferences.field_211294_j, (String)"monsterbox"));
        TileEntitys.MonsterBlock.setRegistryName("monsterbox");
        registryEvent.getRegistry().register(TileEntitys.MonsterBlock);
    }

    static class TileMonsterBlock
    extends ChestTileEntity {
        public TileMonsterBlock() {
            super(TileEntitys.MonsterBlock);
        }

        public NonNullList<ItemStack> getItemss() {
            return this.func_190576_q();
        }
    }

    static class Phone
    extends PokeItem {
        BiConsumer<World, PlayerEntity> working;

        protected Phone(String unlocalizedName, BiConsumer<World, PlayerEntity> working) {
            super(unlocalizedName);
            this.working = working;
        }

        public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
            if (world.func_201670_d()) {
                this.working.accept(world, player);
            }
            return super.func_77659_a(world, player, hand);
        }
    }

    static class PokeLucky
    extends PokeBlock {
        BiConsumer<World, BlockPos> working;

        protected PokeLucky(String unlocalizedName, BiConsumer<World, BlockPos> working) {
            super(unlocalizedName);
            this.working = working;
        }

        public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
            boolean removed = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            if (removed) {
                this.working.accept(world, pos);
            }
            return removed;
        }
    }

    static class MonsterBox
    extends ChestBlock {
        BiConsumer<World, BlockPos> working;

        protected MonsterBox(String unlocalizedName, BiConsumer<World, BlockPos> working) {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.5f).func_200947_a(SoundType.field_185848_a), () -> TileEntityType.field_200972_c);
            this.working = working;
            this.setRegistryName(unlocalizedName);
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult p_225533_6_) {
            if (!world.field_72995_K) {
                world.func_180501_a(pos, net.minecraft.block.Blocks.field_150350_a.func_176223_P(), 3);
            }
            return ActionResultType.SUCCESS;
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState p_196243_4_, boolean p_196243_5_) {
            if (!world.field_72995_K) {
                this.working.accept(world, pos);
            }
        }

        public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
            return new TileMonsterBlock();
        }
    }

    static class PokeItem
    extends Item {
        protected PokeItem(String unlocalizedName) {
            super(new Item.Properties().func_200916_a(Display.UI.Screens.luckytab));
            this.setRegistryName(unlocalizedName);
        }
    }

    static class PokeBlock
    extends Block {
        protected PokeBlock(String unlocalizedName) {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e));
            this.setRegistryName(unlocalizedName);
        }
    }

    public static class TileEntitys {
        public static TileEntityType<TileMonsterBlock> MonsterBlock;
    }

    public static class Items {
        public static Item pokephone = new Phone("poke_phone", (BiConsumer)DistExecutor.safeCallWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeCallable & Serializable)() -> Process.Client.poke_phone));
        public static Item back_case = (Item)new Item(new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(new ResourceLocation("pokelucky", "back_case"));
        public static Item battery = (Item)new Item(new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(new ResourceLocation("pokelucky", "battery"));
        public static Item circuits = (Item)new Item(new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(new ResourceLocation("pokelucky", "circuits"));
        public static Item front_case = (Item)new Item(new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(new ResourceLocation("pokelucky", "front_case"));
        public static Item monitor = (Item)new Item(new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(new ResourceLocation("pokelucky", "monitor"));
        public static Item spawn_musashi = (Item)new ForgeSpawnEggItem(() -> Characters.musashi, 0xFF0000, 0xFF0000, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(new ResourceLocation("pokelucky", "musashi_spawn_egg"));
        public static Item spawn_kojiro = (Item)new ForgeSpawnEggItem(() -> Characters.kojiro, 26367, 26367, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(new ResourceLocation("pokelucky", "kojiro_spawn_egg"));
        public static Item spawn_moster = (Item)new ForgeSpawnEggItem(() -> Characters.monster, 10247936, 10247936, new Item.Properties().func_200916_a(Display.UI.Screens.luckytab)).setRegistryName(new ResourceLocation("pokelucky", "moster_spawn_egg"));
    }

    public static class Blocks {
        public static Block blockrandmon = new PokeLucky("poke_lucky", Process.nomally);
        public static Block blockbackcase = new PokeBlock("back_case_block");
        public static Block blockbattery = new PokeBlock("battery_block");
        public static Block blockcircuits = new PokeBlock("circuits_block");
        public static Block blockfrontcase = new PokeBlock("front_case_block");
        public static Block blockmonitor = new PokeBlock("monitor_block");
        public static Block monsterbox = new MonsterBox("monsterbox", Process.monsterbox);
        public static Block legendrand = new PokeLucky("legendaries_lucky", Process.legendaries);
        public static Block beastrand = new PokeLucky("ultrabeasts_lucky", Process.ultrabeasts);
    }
}

