/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.client.gui;

import com.chefmooon.frightsdelight.common.FoodValues;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class FrightsDelightGUI {
    public static final class_2960 RESOURCE_LOCATION = new class_2960("frightsdelight", "textures/gui/frd_icons.png");
    public static final class_2960 FOOD_LEVEL_ELEMENT = new class_2960("minecraft", "food_level");

    public static void renderNegativeHungerOverlay(HungerType hungerType, class_1657 player, class_310 mc, class_332 graphics, int left, int top) {
        if (player == null) {
            return;
        }
        class_1702 stats = player.method_7344();
        float saturation = stats.method_7589();
        int foodLevel = stats.method_7586();
        int ticks = mc.field_1705.method_1738();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        RenderSystem.enableBlend();
        for (int j = 0; j < 10; ++j) {
            int x = left - j * 8 - 9;
            int y = top;
            if (saturation <= 0.0f && ticks % (foodLevel * 3 + 1) == 0) {
                y = top + (rand.nextInt(3) - 1);
            }
            graphics.method_25302(RESOURCE_LOCATION, x, y, hungerType.getOutlineUOffset(), hungerType.getOutlineVOffset(), 9, 9);
            if (!hungerType.isHasFill()) continue;
            float effectiveHungerOfBar = (float)stats.method_7586() / 2.0f - (float)j;
            if (effectiveHungerOfBar >= 1.0f) {
                graphics.method_25302(RESOURCE_LOCATION, x, y, hungerType.getOutlineUOffset() + hungerType.getUFillOffset(false), 0, 9, 9);
                continue;
            }
            if (!((double)effectiveHungerOfBar >= 0.5)) continue;
            graphics.method_25302(RESOURCE_LOCATION, x, y, hungerType.getOutlineUOffset() + hungerType.getUFillOffset(true), 0, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    public static boolean hasPriorityOverlay(class_1657 player) {
        return player.method_6112(FrightsDelightEffects.FORTIFIED_MIND.get()) != null || player.method_6112(FrightsDelightEffects.UNDEAD_HUNGER.get()) != null;
    }

    public static boolean hasFDOverlay(class_1657 player) {
        return player.method_6112(FoodValues.getNourishment()) != null;
    }

    public static enum HungerType {
        NORMAL(0, 0, 0, false),
        FORTIFIED_MIND(1, 9, 10, false),
        UNDEAD_HUNGER(2, 28, 0, true),
        HYSTERIA(3, 27, 10, false),
        CHILLS(4, 36, 10, false),
        SLIMED(5, 18, 10, false),
        COBWEBBED(6, 0, 10, false),
        INFECTED(7, 0, 0, true);

        private final int index;
        private final int outlineUOffset;
        private final int outlineVOffset;
        private final boolean hasFill;

        private HungerType(int index, int outlineUOffset, int outlineVOffset, boolean hasFill) {
            this.index = index;
            this.outlineUOffset = outlineUOffset;
            this.outlineVOffset = outlineVOffset;
            this.hasFill = hasFill;
        }

        public int getIndex() {
            return this.index;
        }

        public int getOutlineUOffset() {
            return this.outlineUOffset;
        }

        public int getOutlineVOffset() {
            return this.outlineVOffset;
        }

        public boolean isHasFill() {
            return this.hasFill;
        }

        public int getUFillOffset(Boolean half) {
            return half != false ? 9 : 18;
        }
    }
}

