/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightShapes;
import com.chefmooon.frightsdelight.common.tag.CommonTags;
import com.chefmooon.frightsdelight.common.utility.VoxelShapeUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class GlassCupBlock
extends class_2248 {
    public static final int MAX_SERVINGS = 3;
    public static final class_2758 SERVINGS = class_2758.method_11867((String)"servings", (int)0, (int)3);
    public static final class_2753 FACING = class_2741.field_12481;
    public Supplier<class_1792> servingItem;
    public class_2394 particleData;
    protected final ConcurrentHashMap<Integer, class_265[]> CUP_SHAPES;

    public GlassCupBlock(Supplier<class_1792> servingItem, class_4970.class_2251 properties) {
        this(servingItem, null, properties);
    }

    public GlassCupBlock(Supplier<class_1792> servingItem, class_2394 particleData, class_4970.class_2251 properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = particleData;
        this.CUP_SHAPES = GlassCupBlock.buildShapes();
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(0)));
    }

    private static ConcurrentHashMap<Integer, class_265[]> buildShapes() {
        ConcurrentHashMap<Integer, class_265[]> result = new ConcurrentHashMap<Integer, class_265[]>();
        result.put(0, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_1));
        result.put(1, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_2));
        result.put(2, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_3));
        result.put(3, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_4));
        return result;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldStack = player.method_5998(hand);
        if (level.method_8608()) {
            if (heldStack.method_31573(CommonTags.C_TOOLS)) {
                return this.rotate(level, pos, state, player);
            }
            if (heldStack.method_31574(this.servingItem.get())) {
                return this.addServingFromHand(level, pos, state, player, hand);
            }
            if (heldStack.method_7960()) {
                return this.removeServingToHand(level, pos, state, player, hand);
            }
        }
        if (heldStack.method_31573(CommonTags.C_TOOLS)) {
            return this.rotate(level, pos, state, player);
        }
        if (heldStack.method_31574(this.servingItem.get())) {
            return this.addServingFromHand(level, pos, state, player, hand);
        }
        if (heldStack.method_7960()) {
            return this.removeServingToHand(level, pos, state, player, hand);
        }
        return class_1269.field_5814;
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        return facing == class_2350.field_11033 && !stateIn.method_26184((class_4538)level, currentPos) ? class_2246.field_10124.method_9564() : super.method_9559(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        return level.method_8320(pos.method_10074()).method_51367();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, SERVINGS});
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        int servings = (Integer)state.method_11654((class_2769)SERVINGS);
        return this.CUP_SHAPES.containsKey(servings) ? this.CUP_SHAPES.get(servings)[((class_2350)state.method_11654((class_2769)FACING)).method_10161()] : class_259.method_1073();
    }

    public String method_9539() {
        return this.servingItem.get().method_7876();
    }

    protected class_1269 rotate(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (player.method_5829().method_49271(pos.method_46558()) < 0.5) {
            return class_1269.field_21466;
        }
        if (level.method_8652(pos, (class_2680)state.method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)).method_10170()), 3)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_1269 addServingFromHand(class_1937 level, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand) {
        int servings = (Integer)state.method_11654((class_2769)SERVINGS);
        if (servings < 3) {
            class_1799 heldItem = player.method_5998(hand);
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            level.method_8396(player, pos, class_3417.field_14843, class_3419.field_15245, 0.8f, 0.6f);
            if (!player.method_7337()) {
                heldItem.method_7934(1);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected class_1269 removeServingToHand(class_1937 level, class_2338 pos, class_2680 state, class_1657 player, class_1268 hand) {
        int servings = (Integer)state.method_11654((class_2769)SERVINGS);
        class_1799 servingItem = new class_1799((class_1935)this.servingItem.get());
        if (servings == 0) {
            level.method_8650(pos, false);
            level.method_8396(player, pos, class_3417.field_14843, class_3419.field_15245, 0.8f, 0.8f);
            if (!player.method_7337() && !player.method_31548().method_7394(servingItem)) {
                player.method_7328(servingItem, false);
            }
            return class_1269.field_5812;
        }
        if (servings > 0) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
            level.method_8396(player, pos, class_3417.field_14843, class_3419.field_15245, 0.8f, 0.8f);
            if (!player.method_7337() && !player.method_31548().method_7394(servingItem)) {
                player.method_7328(servingItem, false);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_2758 getServingsProperty() {
        return SERVINGS;
    }

    public void animate(class_2680 state, class_1937 level, class_2338 pos, class_3414 soundEvent, class_5819 random) {
        if (Configuration.glassCupParticles() && this.particleData != null) {
            int servings = (Integer)state.method_11654((class_2769)this.getServingsProperty()) + 1;
            class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
            double baseX = (double)pos.method_10263() + 0.5;
            double baseY = (double)pos.method_10264() + 0.5;
            double baseZ = (double)pos.method_10260() + 0.5;
            for (int i = 0; i < servings; ++i) {
                if (random.method_43048(4) != 0) continue;
                double spread = 0.3;
                double xOffset = 0.0;
                double zOffset = 0.0;
                zOffset = switch (i) {
                    case 0 -> {
                        xOffset = -spread;
                        yield -spread;
                    }
                    case 1 -> {
                        xOffset = spread;
                        yield -spread;
                    }
                    case 2 -> {
                        xOffset = spread;
                        yield spread;
                    }
                    case 3 -> {
                        xOffset = -spread;
                        yield spread;
                    }
                    default -> zOffset;
                };
                double rotatedX = 0.0;
                double rotatedZ = 0.0;
                rotatedZ = switch (facing) {
                    case class_2350.field_11043 -> {
                        rotatedX = xOffset;
                        yield zOffset;
                    }
                    case class_2350.field_11035 -> {
                        rotatedX = -xOffset;
                        yield -zOffset;
                    }
                    case class_2350.field_11034 -> {
                        rotatedX = -zOffset;
                        yield xOffset;
                    }
                    case class_2350.field_11039 -> {
                        rotatedX = zOffset;
                        yield -xOffset;
                    }
                    default -> rotatedZ;
                };
                double smallVariation = 0.05;
                level.method_8406(this.particleData, baseX + (rotatedX += (random.method_43058() - 0.5) * smallVariation), baseY + (1.0 - random.method_43058()) / 20.0, baseZ + (rotatedZ += (random.method_43058() - 0.5) * smallVariation), 0.0, 0.0, 0.0);
                if (level.field_9229.method_43048(10) != 0) continue;
                level.method_45446(pos, soundEvent, class_3419.field_15245, 0.2f, 0.8f, false);
            }
        }
    }
}

