/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.client.gui;

import com.chefmooon.frightsdelight.client.gui.fabric.FrightsDelightGUIImpl;
import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.FoodValues;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightEffects;
import com.chefmooon.frightsdelight.common.utility.TextUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9080;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

public class FrightsDelightGUI {
    public static int foodIconsOffset = FrightsDelightGUI.getFoodIconOffset();
    public static final class_2960 RESOURCE_LOCATION = class_2960.method_60655((String)"frightsdelight", (String)"textures/gui/frd_icons.png");

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getFoodIconOffset() {
        return FrightsDelightGUIImpl.getFoodIconOffset();
    }

    public static void renderNegativeHungerOverlay(HungerType hungerType, class_1657 player, class_310 mc, class_332 graphics, int right, int top) {
        class_1702 stats = player.method_7344();
        float saturation = stats.method_7589();
        int foodLevel = stats.method_7586();
        int ticks = mc.field_1705.method_1738();
        Random rand = new Random();
        rand.setSeed(ticks * 312871);
        RenderSystem.enableBlend();
        for (int j = 0; j < 10; ++j) {
            int x = right - j * 8 - 9;
            int y = top;
            if (saturation <= 0.0f && ticks % (foodLevel * 3 + 1) == 0) {
                y = top + (rand.nextInt(3) - 1);
            }
            graphics.method_25302(RESOURCE_LOCATION, x, y, hungerType.getOutlineUOffset(), hungerType.getOutlineVOffset(), 9, 9);
            if (!hungerType.isHasFill()) continue;
            float effectiveHungerOfBar = (float)stats.method_7586() / 2.0f - (float)j;
            if (effectiveHungerOfBar >= 1.0f) {
                graphics.method_25302(RESOURCE_LOCATION, x, y, hungerType.getOutlineUOffset() + hungerType.getUFillOffset(false), 0, 9, 9);
                continue;
            }
            if (!((double)effectiveHungerOfBar >= 0.5)) continue;
            graphics.method_25302(RESOURCE_LOCATION, x, y, hungerType.getOutlineUOffset() + hungerType.getUFillOffset(true), 0, 9, 9);
        }
        RenderSystem.disableBlend();
    }

    public static boolean hasPriorityOverlay(class_1657 player) {
        return player.method_6112(FrightsDelightEffects.FORTIFIED_MIND) != null || player.method_6112(FrightsDelightEffects.UNDEAD_HUNGER) != null;
    }

    public static boolean hasFDOverlay(class_1657 player) {
        return player.method_6112(FoodValues.getNourishment()) != null;
    }

    public static enum HungerType {
        NORMAL(0, 0, 0, false),
        FORTIFIED_MIND(1, 9, 10, false),
        UNDEAD_HUNGER(2, 28, 0, true),
        HYSTERIA(3, 27, 10, false),
        CHILLS(4, 36, 10, false),
        SLIMED(5, 18, 10, false),
        COBWEBBED(6, 0, 10, false),
        INFECTED(7, 0, 0, true);

        private final int index;
        private final int outlineUOffset;
        private final int outlineVOffset;
        private final boolean hasFill;

        private HungerType(int index, int outlineUOffset, int outlineVOffset, boolean hasFill) {
            this.index = index;
            this.outlineUOffset = outlineUOffset;
            this.outlineVOffset = outlineVOffset;
            this.hasFill = hasFill;
        }

        public int getIndex() {
            return this.index;
        }

        public int getOutlineUOffset() {
            return this.outlineUOffset;
        }

        public int getOutlineVOffset() {
            return this.outlineVOffset;
        }

        public boolean isHasFill() {
            return this.hasFill;
        }

        public int getUFillOffset(Boolean half) {
            return half != false ? 9 : 18;
        }
    }

    public static class UndeadHungerOverlay
    extends BaseOverlay {
        public static final class_2960 ID = TextUtils.res("undead_hunger");
        public static final UndeadHungerOverlay INSTANCE = new UndeadHungerOverlay();

        @Override
        public void render(class_310 mc, class_1657 player, class_332 graphics, int left, int right, int top, int guiTicks) {
            if (player.method_6112(FrightsDelightEffects.UNDEAD_HUNGER) != null) {
                FrightsDelightGUI.renderNegativeHungerOverlay(HungerType.UNDEAD_HUNGER, player, mc, graphics, right, top - foodIconsOffset);
            }
        }

        @Override
        public boolean shouldRenderOverlay(class_310 minecraft, class_1657 player, class_332 guiGraphics, int guiTicks) {
            if (!Configuration.undeadHungerOverlay()) {
                return false;
            }
            if (FrightsDelightGUI.hasFDOverlay(player)) {
                return false;
            }
            return super.shouldRenderOverlay(minecraft, player, guiGraphics, guiTicks);
        }
    }

    public static class SlimedOverlay
    extends BaseOverlay {
        public static final class_2960 ID = TextUtils.res("slimed");
        public static final SlimedOverlay INSTANCE = new SlimedOverlay();

        @Override
        public void render(class_310 mc, class_1657 player, class_332 graphics, int left, int right, int top, int guiTicks) {
            if (player.method_6112(FrightsDelightEffects.SLIMED) != null) {
                FrightsDelightGUI.renderNegativeHungerOverlay(HungerType.SLIMED, player, mc, graphics, right, top - foodIconsOffset);
            }
        }

        @Override
        public boolean shouldRenderOverlay(class_310 minecraft, class_1657 player, class_332 guiGraphics, int guiTicks) {
            if (!Configuration.slimedOverlay()) {
                return false;
            }
            if (FrightsDelightGUI.hasPriorityOverlay(player)) {
                return false;
            }
            if (FrightsDelightGUI.hasFDOverlay(player)) {
                return false;
            }
            return super.shouldRenderOverlay(minecraft, player, guiGraphics, guiTicks);
        }
    }

    public static class InfectedOverlay
    extends BaseOverlay {
        public static final class_2960 ID = TextUtils.res("infected");
        public static final InfectedOverlay INSTANCE = new InfectedOverlay();

        @Override
        public void render(class_310 mc, class_1657 player, class_332 graphics, int left, int right, int top, int guiTicks) {
            if (player.method_6112(FrightsDelightEffects.INFECTED) != null) {
                FrightsDelightGUI.renderNegativeHungerOverlay(HungerType.INFECTED, player, mc, graphics, right, top - foodIconsOffset);
            }
        }

        @Override
        public boolean shouldRenderOverlay(class_310 minecraft, class_1657 player, class_332 guiGraphics, int guiTicks) {
            if (!Configuration.infectedOverlay()) {
                return false;
            }
            if (FrightsDelightGUI.hasPriorityOverlay(player)) {
                return false;
            }
            if (FrightsDelightGUI.hasFDOverlay(player)) {
                return false;
            }
            return super.shouldRenderOverlay(minecraft, player, guiGraphics, guiTicks);
        }
    }

    public static class HysteriaOverlay
    extends BaseOverlay {
        public static final class_2960 ID = TextUtils.res("hysteria");
        public static final HysteriaOverlay INSTANCE = new HysteriaOverlay();

        @Override
        public void render(class_310 mc, class_1657 player, class_332 graphics, int left, int right, int top, int guiTicks) {
            if (player.method_6112(FrightsDelightEffects.HYSTERIA) != null) {
                FrightsDelightGUI.renderNegativeHungerOverlay(HungerType.HYSTERIA, player, mc, graphics, right, top - foodIconsOffset);
            }
        }

        @Override
        public boolean shouldRenderOverlay(class_310 minecraft, class_1657 player, class_332 guiGraphics, int guiTicks) {
            if (!Configuration.hysteriaOverlay()) {
                return false;
            }
            if (FrightsDelightGUI.hasFDOverlay(player)) {
                return false;
            }
            return super.shouldRenderOverlay(minecraft, player, guiGraphics, guiTicks);
        }
    }

    public static class FortifiedMindOverlay
    extends BaseOverlay {
        public static final class_2960 ID = TextUtils.res("fortified_mind");
        public static final FortifiedMindOverlay INSTANCE = new FortifiedMindOverlay();

        @Override
        public void render(class_310 mc, class_1657 player, class_332 graphics, int left, int right, int top, int guiTicks) {
            if (player.method_6112(FrightsDelightEffects.FORTIFIED_MIND) != null) {
                FrightsDelightGUI.renderNegativeHungerOverlay(HungerType.FORTIFIED_MIND, player, mc, graphics, right, top - foodIconsOffset);
            }
        }

        @Override
        public boolean shouldRenderOverlay(class_310 minecraft, class_1657 player, class_332 guiGraphics, int guiTicks) {
            if (!Configuration.fortifiedMindOverlay()) {
                return false;
            }
            if (FrightsDelightGUI.hasFDOverlay(player)) {
                return false;
            }
            return super.shouldRenderOverlay(minecraft, player, guiGraphics, guiTicks);
        }
    }

    public static class CobwebbedOverlay
    extends BaseOverlay {
        public static final class_2960 ID = TextUtils.res("cobwebbed");
        public static final CobwebbedOverlay INSTANCE = new CobwebbedOverlay();

        @Override
        public void render(class_310 mc, class_1657 player, class_332 graphics, int left, int right, int top, int guiTicks) {
            if (player.method_6112(FrightsDelightEffects.COBWEBBED) != null) {
                FrightsDelightGUI.renderNegativeHungerOverlay(HungerType.COBWEBBED, player, mc, graphics, right, top - foodIconsOffset);
            }
        }

        @Override
        public boolean shouldRenderOverlay(class_310 minecraft, class_1657 player, class_332 guiGraphics, int guiTicks) {
            if (!Configuration.cobwebbedOverlay()) {
                return false;
            }
            if (FrightsDelightGUI.hasPriorityOverlay(player)) {
                return false;
            }
            if (FrightsDelightGUI.hasFDOverlay(player)) {
                return false;
            }
            return super.shouldRenderOverlay(minecraft, player, guiGraphics, guiTicks);
        }
    }

    public static class ChillsOverlay
    extends BaseOverlay {
        public static final class_2960 ID = TextUtils.res("chills");
        public static final ChillsOverlay INSTANCE = new ChillsOverlay();

        @Override
        public void render(class_310 mc, class_1657 player, class_332 graphics, int left, int right, int top, int guiTicks) {
            if (player.method_6112(FrightsDelightEffects.CHILLS) != null) {
                FrightsDelightGUI.renderNegativeHungerOverlay(HungerType.CHILLS, player, mc, graphics, right, top - foodIconsOffset);
            }
        }

        @Override
        public boolean shouldRenderOverlay(class_310 minecraft, class_1657 player, class_332 guiGraphics, int guiTicks) {
            if (!Configuration.chillsOverlay()) {
                return false;
            }
            if (FrightsDelightGUI.hasFDOverlay(player)) {
                return false;
            }
            return super.shouldRenderOverlay(minecraft, player, guiGraphics, guiTicks);
        }
    }

    public static abstract class BaseOverlay
    implements class_9080.class_9081 {
        public abstract void render(class_310 var1, class_1657 var2, class_332 var3, int var4, int var5, int var6, int var7);

        public final void render(@NotNull class_332 guiGraphics, @NotNull class_9779 deltaTracker) {
            class_310 minecraft = class_310.method_1551();
            if (minecraft.field_1724 == null || !this.shouldRenderOverlay(minecraft, (class_1657)minecraft.field_1724, guiGraphics, minecraft.field_1705.method_1738())) {
                return;
            }
            int top = guiGraphics.method_51443();
            int left = guiGraphics.method_51421() / 2 - 91;
            int right = guiGraphics.method_51421() / 2 + 91;
            this.render(minecraft, (class_1657)minecraft.field_1724, guiGraphics, left, right, top, minecraft.field_1705.method_1738());
        }

        public boolean shouldRenderOverlay(class_310 minecraft, class_1657 player, class_332 guiGraphics, int guiTicks) {
            return !minecraft.field_1690.field_1842 && minecraft.field_1761 != null && minecraft.field_1761.method_2908();
        }
    }
}

