/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.entity.CandyBasketBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractCandyBasketBlock
extends class_2237
implements class_3737 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    protected static final class_265 SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private CandyBasketType candyBasketType = CandyBasketType.NONE;

    public AbstractCandyBasketBlock(class_4970.class_2251 properties, CandyBasketType type) {
        this(properties);
        this.candyBasketType = type;
    }

    public AbstractCandyBasketBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return Objects.requireNonNull((class_2591)class_7923.field_41181.method_10223(FrightsDelightBlockEntities.CANDY_BASKET)).method_11032(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED});
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = level.method_8321(pos);
        if (!(blockEntity instanceof CandyBasketBlockEntity)) {
            return class_1269.field_5811;
        }
        class_1799 mainHandItem = player.method_5998(hand);
        if (!player.method_21823()) {
            if (!mainHandItem.method_7960() || player.method_5998(class_1268.field_5808).method_7960() && !player.method_5998(class_1268.field_5810).method_7960()) {
                if (!mainHandItem.method_19267()) {
                    return class_1269.field_5814;
                }
                boolean addItem = AbstractCandyBasketBlock.addItem(mainHandItem, level, pos);
                if (addItem) {
                    Supplier<class_3414> addSound;
                    if (!player.method_31549().field_7477) {
                        mainHandItem.method_7971(1);
                    }
                    if ((addSound = this.candyBasketType.getAddSound()) != null) {
                        level.method_45446(pos, addSound.get(), class_3419.field_15245, 0.4f, 1.0f, false);
                    }
                    return class_1269.field_5812;
                }
            } else {
                class_1799 removeItem = AbstractCandyBasketBlock.removeItem(level, pos);
                if (!removeItem.method_7960()) {
                    Supplier<class_3414> removeSound;
                    if (!player.method_31549().field_7477 && player.method_31548().method_7394(removeItem)) {
                        player.method_7328(removeItem, false);
                    }
                    if ((removeSound = this.candyBasketType.getRemoveSound()) != null) {
                        level.method_45446(pos, removeSound.get(), class_3419.field_15245, 0.4f, 0.6f, false);
                    }
                    return class_1269.field_5812;
                }
                level.method_45446(pos, FrightsDelightSounds.BLOCK_CANDY_BASKET_EMPTY.get(), class_3419.field_15245, 0.4f, 0.6f, false);
            }
        }
        return class_1269.field_5811;
    }

    public CandyBasketType getCandyBasketType() {
        return this.candyBasketType;
    }

    public static boolean addItem(class_1799 itemStack, class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.addItem(itemStack);
        }
        return false;
    }

    public static class_1799 removeItem(class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.removeItem();
        }
        return class_1799.field_8037;
    }

    public static boolean shuffleInventory(class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.shuffleInventory();
        }
        return false;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluid = context.method_8045().method_8316(context.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.method_15772() == class_3612.field_15910));
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof class_1263) {
            class_1263 container = (class_1263)blockEntity;
            int count = 0;
            for (int i = 0; i < container.method_5439(); ++i) {
                if (container.method_5438(i).method_7960()) continue;
                ++count;
            }
            if (count > 0) {
                return count * 14 / container.method_5439() + 1;
            }
        }
        return 0;
    }

    @NotNull
    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_1799 itemStack = super.method_9574(level, pos, state);
        class_2591 blockEntityType = (class_2591)class_7923.field_41181.method_10223(FrightsDelightBlockEntities.CANDY_BASKET);
        if (blockEntityType != null && level.method_8321(pos) instanceof CandyBasketBlockEntity) {
            level.method_35230(pos, blockEntityType).ifPresent(blockEntity -> blockEntity.method_38240(itemStack));
        }
        return itemStack;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_9568(stack, level, tooltip, flag);
        class_2487 compoundTag = class_1747.method_38072((class_1799)stack);
        if (compoundTag != null && compoundTag.method_10573("Items", 9)) {
            class_2371 nonNullList = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)compoundTag, (class_2371)nonNullList);
            for (class_1799 itemStack : nonNullList) {
                if (itemStack.method_7960()) continue;
                tooltip.add((class_2561)itemStack.method_7964().method_27661());
            }
        }
    }

    public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            if (!level.field_9236 && player.method_7337() && !candyBasketBlockEntity.method_5442()) {
                class_1799 itemStack = new class_1799((class_1935)this);
                candyBasketBlockEntity.method_38240(itemStack);
                if (candyBasketBlockEntity.method_16914()) {
                    itemStack.method_7977(candyBasketBlockEntity.method_5797());
                }
                class_1542 itemEntity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                itemEntity.method_6988();
                level.method_8649((class_1297)itemEntity);
            }
            level.method_8452(pos, class_2246.field_10124);
        }
        super.method_9576(level, pos, state, player);
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2586 blockEntity;
        if (stack.method_7938() && (blockEntity = level.method_8321(pos)) instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            candyBasketBlockEntity.setCustomName(stack.method_7964());
        }
        super.method_9567(level, pos, state, placer, stack);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean movedByPiston) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof CandyBasketBlockEntity) {
                level.method_8455(pos, state.method_26204());
            }
            super.method_9536(state, level, pos, newState, movedByPiston);
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }
}

