/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.item;

import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightAdvancements;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1262;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class CandyBasketItem
extends class_1747 {
    private CandyBasketType candyBasketType;

    public CandyBasketItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public CandyBasketItem(class_2248 block, class_1792.class_1793 properties, CandyBasketType type) {
        this(block, properties);
        this.candyBasketType = type;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1268 offHand = usedHand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        class_1799 basketStack = player.method_5998(usedHand);
        class_1799 offHandStack = player.method_5998(offHand);
        if (player.method_18276()) {
            return this.shuffleItems(level, player, basketStack);
        }
        if (offHandStack.method_7960()) {
            return this.removeItem(level, player, offHand, basketStack, offHandStack);
        }
        return this.addItem(level, player, basketStack, offHandStack);
    }

    public class_1271<class_1799> shuffleItems(class_1937 level, class_1657 player, class_1799 basketStack) {
        class_2487 compoundTag = class_1747.method_38072((class_1799)basketStack);
        if (compoundTag != null && compoundTag.method_10573("Items", 9)) {
            class_2371 nonNullList = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)compoundTag, (class_2371)nonNullList);
            ArrayList<class_1799> itemStackList = new ArrayList<class_1799>(List.of());
            if (!nonNullList.isEmpty()) {
                for (class_1799 itemStack : nonNullList) {
                    if (itemStack.method_7960()) continue;
                    itemStackList.add(itemStack);
                }
                if (itemStackList.size() > 1) {
                    int i;
                    for (i = 0; i < itemStackList.size(); ++i) {
                        int randomIndex = (int)(Math.random() * (double)itemStackList.size());
                        class_1799 temp = (class_1799)itemStackList.get(randomIndex);
                        itemStackList.set(randomIndex, (class_1799)itemStackList.get(i));
                        itemStackList.set(i, temp);
                    }
                    nonNullList.clear();
                    for (i = 0; i < itemStackList.size(); ++i) {
                        nonNullList.set(i, (Object)((class_1799)itemStackList.get(i)));
                    }
                    class_1262.method_5426((class_2487)compoundTag, (class_2371)nonNullList);
                    basketStack.method_7959("Items", (class_2520)compoundTag);
                    Supplier<class_3414> shuffleSound = this.candyBasketType.getShuffleSound();
                    if (shuffleSound != null) {
                        level.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), shuffleSound.get(), class_3419.field_15248, Math.min(0.3f + 0.04f * (float)itemStackList.size(), 1.0f), 1.0f, false);
                    }
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        FrightsDelightAdvancements.CANDY_BASKET_SHUFFLE_TRIGGER.trigger(serverPlayer);
                    }
                    return class_1271.method_22427((Object)basketStack);
                }
            }
        }
        return class_1271.method_22430((Object)basketStack);
    }

    public class_1271<class_1799> removeItem(class_1937 level, class_1657 player, class_1268 offHand, class_1799 basketStack, class_1799 offHandStack) {
        class_2487 compoundTag = class_1747.method_38072((class_1799)basketStack);
        if (compoundTag != null && compoundTag.method_10573("Items", 9)) {
            class_2371 nonNullList = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)compoundTag, (class_2371)nonNullList);
            ArrayList<class_1799> itemStackList = new ArrayList<class_1799>(List.of());
            if (!nonNullList.isEmpty()) {
                for (class_1799 itemStack : nonNullList) {
                    if (itemStack.method_7960()) continue;
                    itemStackList.add(itemStack);
                }
                if (!itemStackList.isEmpty() && offHandStack.method_7960()) {
                    int i;
                    class_1799 toRemove = class_1799.field_8037;
                    for (i = itemStackList.size() - 1; i >= 0; --i) {
                        class_1799 candidate = (class_1799)itemStackList.get(i);
                        if (candidate.method_7960()) continue;
                        toRemove = candidate.method_7972();
                        itemStackList.remove(i);
                        break;
                    }
                    if (!toRemove.method_7960()) {
                        if (!player.method_31549().field_7477) {
                            player.method_6122(offHand, toRemove);
                        }
                        nonNullList.clear();
                        for (i = 0; i < itemStackList.size(); ++i) {
                            nonNullList.set(i, (Object)((class_1799)itemStackList.get(i)));
                        }
                        class_1262.method_5426((class_2487)compoundTag, (class_2371)nonNullList);
                        basketStack.method_7959("Items", (class_2520)compoundTag);
                        Supplier<class_3414> removeSound = this.candyBasketType.getRemoveSound();
                        if (removeSound != null) {
                            level.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), removeSound.get(), class_3419.field_15248, 0.4f, 1.0f, false);
                        }
                        return class_1271.method_22427((Object)basketStack);
                    }
                }
            }
        }
        return class_1271.method_22430((Object)basketStack);
    }

    public class_1271<class_1799> addItem(class_1937 level, class_1657 player, class_1799 basketStack, class_1799 offHandStack) {
        if (!offHandStack.method_19267()) {
            return class_1271.method_22431((Object)offHandStack);
        }
        class_2487 compoundTag = class_1747.method_38072((class_1799)basketStack);
        if (compoundTag != null) {
            if (compoundTag.method_10573("Items", 9)) {
                class_2371 nonNullList = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
                class_1262.method_5429((class_2487)compoundTag, (class_2371)nonNullList);
                ArrayList<class_1799> itemStackList = new ArrayList<class_1799>(List.of());
                if (!nonNullList.isEmpty()) {
                    for (class_1799 itemStack : nonNullList) {
                        if (itemStack.method_7960()) continue;
                        itemStackList.add(itemStack);
                    }
                    if (itemStackList.size() < 9 && !offHandStack.method_7960()) {
                        class_1799 toAdd = player.method_31549().field_7477 ? offHandStack.method_46651(1) : offHandStack.method_7971(1);
                        itemStackList.add(toAdd);
                        nonNullList.clear();
                        for (int i = 0; i < itemStackList.size(); ++i) {
                            nonNullList.set(i, (Object)((class_1799)itemStackList.get(i)));
                        }
                        class_1262.method_5426((class_2487)compoundTag, (class_2371)nonNullList);
                        basketStack.method_7959("Items", (class_2520)compoundTag);
                        Supplier<class_3414> addSound = this.candyBasketType.getAddSound();
                        if (addSound != null) {
                            level.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), addSound.get(), class_3419.field_15248, 0.4f, 1.0f, false);
                        }
                        return class_1271.method_22427((Object)basketStack);
                    }
                }
            }
        } else {
            Supplier<class_3414> addSound;
            class_2487 newTag = new class_2487();
            class_2371 nonNullList = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
            if (!offHandStack.method_7960()) {
                class_1799 toAdd = player.method_31549().field_7477 ? offHandStack.method_46651(1) : offHandStack.method_7971(1);
                nonNullList.set(0, (Object)toAdd);
                class_1262.method_5426((class_2487)newTag, (class_2371)nonNullList);
                basketStack.method_7959("Items", (class_2520)newTag);
                class_1747.method_38073((class_1799)basketStack, (class_2591)Objects.requireNonNull((class_2591)class_7923.field_41181.method_10223(FrightsDelightBlockEntities.CANDY_BASKET)), (class_2487)newTag);
            }
            if ((addSound = this.candyBasketType.getAddSound()) != null) {
                level.method_8486(player.method_23317(), player.method_23318(), player.method_23321(), addSound.get(), class_3419.field_15248, 0.4f, 1.0f, false);
            }
            return class_1271.method_22427((Object)basketStack);
        }
        return class_1271.method_22430((Object)basketStack);
    }
}

