/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.client.neoforge;

import com.chefmooon.frightsdelight.client.FrightsDelightClient;
import com.chefmooon.frightsdelight.common.registry.neoforge.FrightsDelightBlocksImpl;
import com.chefmooon.frightsdelight.common.utility.TextUtils;
import com.chefmooon.frightsdelight.common.utility.neoforge.FrightsDelightItemPropertiesImpl;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.resource.EmptyPackResources;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;

public class FrightsDelightClientImpl {
    public static void init(FMLClientSetupEvent event) {
        FrightsDelightClient.init();
        event.enqueueWork(() -> {
            FrightsDelightItemPropertiesImpl.addCustomItemProperties();
            FrightsDelightClientImpl.registerFluidRenderLayers();
        });
    }

    public static void registerFluidRenderLayers() {
        FrightsDelightClientImpl.setFluidRenderLayer(FrightsDelightBlocksImpl.ROTTEN_FLESH_SYRUP.get());
        FrightsDelightClientImpl.setFluidRenderLayer(FrightsDelightBlocksImpl.SLIMEAPPLE_SYRUP.get());
        FrightsDelightClientImpl.setFluidRenderLayer(FrightsDelightBlocksImpl.SPIDEREYE_SYRUP.get());
        FrightsDelightClientImpl.setFluidRenderLayer(FrightsDelightBlocksImpl.GHASTTEAR_SYRUP.get());
        FrightsDelightClientImpl.setFluidRenderLayer(FrightsDelightBlocksImpl.SOUL_BERRY_SYRUP.get());
        FrightsDelightClientImpl.setFluidRenderLayer(FrightsDelightBlocksImpl.WITHER_BERRY_SYRUP.get());
        FrightsDelightClientImpl.setFluidRenderLayer(FrightsDelightBlocksImpl.COBWEB_SYRUP.get());
    }

    public static void setFluidRenderLayer(LiquidBlock liquidBlock) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)liquidBlock.fluid.getFlowing(), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)liquidBlock.fluid.getSource(), (RenderType)RenderType.translucent());
    }

    public static void onBuiltinPackRegistration(AddPackFindersEvent event) {
        if (FrightsDelightClientImpl.isModLoaded("presencefootsteps")) {
            FrightsDelightClientImpl.registerBuiltinResourcePack(event, Component.literal((String)"frightsdelight/frdpresencefootsteps"), "frdpresencefootsteps");
        }
    }

    private static void registerBuiltinResourcePack(AddPackFindersEvent event, MutableComponent name, String folder) {
        IModFileInfo modFileInfo = ModList.get().getModFileById("frightsdelight");
        if (modFileInfo == null) {
            return;
        }
        String path = TextUtils.res(folder).toString();
        IModFile modFile = modFileInfo.getFile();
        event.addRepositorySource(consumer -> consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo(path, (Component)name, PackSource.DEFAULT, Optional.of(new KnownPack("frightsdelight", modFile.findResource(new String[]{"resourcepacks/" + folder}).toString(), "15"))), (Pack.ResourcesSupplier)new EmptyPackResources.EmptyResourcesSupplier(new PackMetadataSection((Component)Component.literal((String)("frightsdelight/" + folder)), SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES))), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false))));
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }
}

