/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.client.renderer.neoforge;

import com.chefmooon.frightsdelight.client.renderer.LollipopMoldBlockEntityRenderer;
import com.chefmooon.frightsdelight.common.block.LollipopMoldBlock;
import com.chefmooon.frightsdelight.common.block.entity.LollipopMoldBlockEntity;
import com.chefmooon.frightsdelight.common.registry.neoforge.FrightsDelightItemsImpl;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LollipopMoldBlockEntityRendererImpl
extends LollipopMoldBlockEntityRenderer
implements BlockEntityRenderer<LollipopMoldBlockEntity> {
    public LollipopMoldBlockEntityRendererImpl(BlockEntityRendererProvider.Context context) {
    }

    public void render(LollipopMoldBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = blockEntity.getLevel();
        Minecraft minecraft = Minecraft.getInstance();
        if (level == null) {
            return;
        }
        BlockState state = level.getBlockState(blockEntity.getBlockPos());
        if (!(state.getBlock() instanceof LollipopMoldBlock)) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)LollipopMoldBlock.FACING);
        Direction.Axis axis = facing.getAxis();
        boolean facingAxisX = axis == Direction.Axis.X;
        int shards = (Integer)state.getValue((Property)LollipopMoldBlock.SHARDS);
        if (shards >= 1) {
            poseStack.pushPose();
            this.transformShard1(poseStack, facingAxisX);
            minecraft.getItemRenderer().renderStatic(new ItemStack((ItemLike)FrightsDelightItemsImpl.BONE_SHARD.get()), ItemDisplayContext.FIXED, LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos()), packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), (int)blockEntity.getBlockPos().asLong());
            poseStack.popPose();
        }
        if (shards >= 2) {
            poseStack.pushPose();
            this.transformShard2(poseStack, facingAxisX);
            minecraft.getItemRenderer().renderStatic(new ItemStack((ItemLike)FrightsDelightItemsImpl.BONE_SHARD.get()), ItemDisplayContext.FIXED, LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos()), packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), (int)blockEntity.getBlockPos().asLong());
            poseStack.popPose();
        }
        if (shards >= 3) {
            poseStack.pushPose();
            this.transformShard3(poseStack, facingAxisX);
            minecraft.getItemRenderer().renderStatic(new ItemStack((ItemLike)FrightsDelightItemsImpl.BONE_SHARD.get()), ItemDisplayContext.FIXED, LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos()), packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), (int)blockEntity.getBlockPos().asLong());
            poseStack.popPose();
        }
        if (shards >= 4) {
            poseStack.pushPose();
            this.transformShard4(poseStack, facingAxisX);
            minecraft.getItemRenderer().renderStatic(new ItemStack((ItemLike)FrightsDelightItemsImpl.BONE_SHARD.get()), ItemDisplayContext.FIXED, LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos()), packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), (int)blockEntity.getBlockPos().asLong());
            poseStack.popPose();
        }
    }
}

