/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.block.entity.base.BaseCandyMoldBlockEntity;
import com.chefmooon.frightsdelight.common.block.state.properties.FrightsDelightBlockStateProperties;
import com.chefmooon.frightsdelight.common.block.state.properties.SyrupTypeProperty;
import com.chefmooon.frightsdelight.common.data.types.Syrups;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AbstractMoldBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static Map<ResourceLocation, Syrups> ITEM_TO_SYRUP = Map.of(Syrups.ROTTEN_FLESH.getSyrupBottleItem(), Syrups.ROTTEN_FLESH, Syrups.SLIMEAPPLE.getSyrupBottleItem(), Syrups.SLIMEAPPLE, Syrups.SPIDEREYE.getSyrupBottleItem(), Syrups.SPIDEREYE, Syrups.GHASTTEAR.getSyrupBottleItem(), Syrups.GHASTTEAR, Syrups.SOUL_BERRY.getSyrupBottleItem(), Syrups.SOUL_BERRY, Syrups.WITHER_BERRY.getSyrupBottleItem(), Syrups.WITHER_BERRY, Syrups.COBWEB.getSyrupBottleItem(), Syrups.COBWEB);
    public static final MapCodec<AbstractMoldBlock> CODEC = AbstractMoldBlock.simpleCodec(AbstractMoldBlock::new);
    public static final SyrupTypeProperty SYRUP_TYPE = FrightsDelightBlockStateProperties.SYRUP_TYPE;
    public static final BooleanProperty HARDENED = FrightsDelightBlockStateProperties.HARDENED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);

    protected AbstractMoldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY))).setValue((Property)HARDENED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return stateIn;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SYRUP_TYPE, HARDENED, FACING, WATERLOGGED});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluid = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            super.onRemove(state, level, pos, newState, movedByPiston);
            if (blockEntity instanceof BaseCandyMoldBlockEntity) {
                level.updateNeighbourForOutputSignal(pos, state.getBlock());
            }
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Syrups syrup;
        if (Configuration.candyMoldParticles() && (syrup = (Syrups)((Object)state.getValue((Property)SYRUP_TYPE))) != Syrups.EMPTY && !((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
            double d = (double)pos.getX() + 0.5;
            double e = (double)pos.getY() + 0.2;
            double f = (double)pos.getZ() + 0.5;
            if (random.nextInt(4) == 0) {
                SimpleParticleType particleData;
                SimpleParticleType simpleParticleType = particleData = syrup.getParticle() != null ? syrup.getParticle().get() : null;
                if (particleData != null) {
                    level.addParticle((ParticleOptions)particleData, d + (random.nextDouble() - 0.5) / 2.0, e + (1.0 - random.nextDouble()) / 20.0, f + (random.nextDouble() - 0.5) / 2.0, 0.0, 0.0, 0.0);
                    if (syrup.getAnimateSound() != null && level.random.nextInt(10) == 0) {
                        level.playLocalSound(pos, syrup.getAnimateSound().get(), SoundSource.BLOCKS, 0.2f, 0.8f, false);
                    }
                }
            }
        }
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

