/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightShapes;
import com.chefmooon.frightsdelight.common.tag.CommonTags;
import com.chefmooon.frightsdelight.common.utility.VoxelShapeUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlassCupBlock
extends Block {
    public static final int MAX_SERVINGS = 3;
    public static final IntegerProperty SERVINGS = IntegerProperty.create((String)"servings", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public Supplier<Item> servingItem;
    public ParticleOptions particleData;
    protected final ConcurrentHashMap<Integer, VoxelShape[]> CUP_SHAPES;

    public GlassCupBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties) {
        this(servingItem, null, properties);
    }

    public GlassCupBlock(Supplier<Item> servingItem, ParticleOptions particleData, BlockBehaviour.Properties properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = particleData;
        this.CUP_SHAPES = GlassCupBlock.buildShapes();
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SERVINGS, (Comparable)Integer.valueOf(0)));
    }

    private static ConcurrentHashMap<Integer, VoxelShape[]> buildShapes() {
        ConcurrentHashMap<Integer, VoxelShape[]> result = new ConcurrentHashMap<Integer, VoxelShape[]>();
        result.put(0, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_1));
        result.put(1, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_2));
        result.put(2, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_3));
        result.put(3, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_4));
        return result;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide()) {
            if (heldStack.is(CommonTags.C_TOOLS)) {
                return this.rotate(level, pos, state, player);
            }
            if (heldStack.is(this.servingItem.get())) {
                return this.addServingFromHand(level, pos, state, player, hand);
            }
            if (heldStack.isEmpty()) {
                return this.removeServingToHand(level, pos, state, player, hand);
            }
        }
        if (heldStack.is(CommonTags.C_TOOLS)) {
            return this.rotate(level, pos, state, player);
        }
        if (heldStack.is(this.servingItem.get())) {
            return this.addServingFromHand(level, pos, state, player, hand);
        }
        if (heldStack.isEmpty()) {
            return this.removeServingToHand(level, pos, state, player, hand);
        }
        return ItemInteractionResult.FAIL;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, SERVINGS});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        return this.CUP_SHAPES.containsKey(servings) ? this.CUP_SHAPES.get(servings)[((Direction)state.getValue((Property)FACING)).get2DDataValue()] : Shapes.empty();
    }

    public String getDescriptionId() {
        return this.servingItem.get().getDescriptionId();
    }

    protected ItemInteractionResult rotate(Level level, BlockPos pos, BlockState state, Player player) {
        if (player.getBoundingBox().distanceToSqr(pos.getBottomCenter()) < 0.5) {
            return ItemInteractionResult.CONSUME;
        }
        if (level.setBlock(pos, (BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getClockWise()), 3)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public ItemInteractionResult addServingFromHand(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        if (servings < 3) {
            ItemStack heldItem = player.getItemInHand(hand);
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            level.playSound(player, pos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS, 0.8f, 0.6f);
            if (!player.isCreative()) {
                heldItem.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected ItemInteractionResult removeServingToHand(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.getValue((Property)SERVINGS);
        ItemStack servingItem = new ItemStack((ItemLike)this.servingItem.get());
        if (servings == 0) {
            level.removeBlock(pos, false);
            level.playSound(player, pos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS, 0.8f, 0.8f);
            if (!player.isCreative() && !player.getInventory().add(servingItem)) {
                player.drop(servingItem, false);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (servings > 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
            level.playSound(player, pos, SoundEvents.GLASS_PLACE, SoundSource.BLOCKS, 0.8f, 0.8f);
            if (!player.isCreative() && !player.getInventory().add(servingItem)) {
                player.drop(servingItem, false);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public void animate(BlockState state, Level level, BlockPos pos, SoundEvent soundEvent, RandomSource random) {
        if (Configuration.glassCupParticles() && this.particleData != null) {
            int servings = (Integer)state.getValue((Property)this.getServingsProperty()) + 1;
            Direction facing = (Direction)state.getValue((Property)FACING);
            double baseX = (double)pos.getX() + 0.5;
            double baseY = (double)pos.getY() + 0.5;
            double baseZ = (double)pos.getZ() + 0.5;
            for (int i = 0; i < servings; ++i) {
                if (random.nextInt(4) != 0) continue;
                double spread = 0.3;
                double xOffset = 0.0;
                double zOffset = 0.0;
                zOffset = switch (i) {
                    case 0 -> {
                        xOffset = -spread;
                        yield -spread;
                    }
                    case 1 -> {
                        xOffset = spread;
                        yield -spread;
                    }
                    case 2 -> {
                        xOffset = spread;
                        yield spread;
                    }
                    case 3 -> {
                        xOffset = -spread;
                        yield spread;
                    }
                    default -> zOffset;
                };
                double rotatedX = 0.0;
                double rotatedZ = 0.0;
                rotatedZ = switch (facing) {
                    case Direction.NORTH -> {
                        rotatedX = xOffset;
                        yield zOffset;
                    }
                    case Direction.SOUTH -> {
                        rotatedX = -xOffset;
                        yield -zOffset;
                    }
                    case Direction.EAST -> {
                        rotatedX = -zOffset;
                        yield xOffset;
                    }
                    case Direction.WEST -> {
                        rotatedX = zOffset;
                        yield -xOffset;
                    }
                    default -> rotatedZ;
                };
                double smallVariation = 0.05;
                level.addParticle(this.particleData, baseX + (rotatedX += (random.nextDouble() - 0.5) * smallVariation), baseY + (1.0 - random.nextDouble()) / 20.0, baseZ + (rotatedZ += (random.nextDouble() - 0.5) * smallVariation), 0.0, 0.0, 0.0);
                if (level.random.nextInt(10) != 0) continue;
                level.playLocalSound(pos, soundEvent, SoundSource.BLOCKS, 0.2f, 0.8f, false);
            }
        }
    }
}

