/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.AbstractMoldBlock;
import com.chefmooon.frightsdelight.common.block.entity.LollipopMoldBlockEntity;
import com.chefmooon.frightsdelight.common.block.entity.base.BaseCandyMoldBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.Syrups;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightItems;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LollipopMoldBlock
extends AbstractMoldBlock {
    public static final IntegerProperty SHARDS = IntegerProperty.create((String)"shards", (int)0, (int)4);

    public LollipopMoldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SHARDS, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY))).setValue((Property)HARDENED, (Comparable)Boolean.FALSE));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SHARDS});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LollipopMoldBlockEntity) {
            ItemStack mainHandItem = player.getItemInHand(hand);
            Syrups syrup = (Syrups)((Object)state.getValue((Property)SYRUP_TYPE));
            if (!((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
                if (mainHandItem.is((Item)BuiltInRegistries.ITEM.get(FrightsDelightItems.BONE_SHARD))) {
                    int currentShards = (Integer)state.getValue((Property)SHARDS);
                    if (currentShards < 4) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)SHARDS, (Comparable)Integer.valueOf(currentShards + 1)), 3);
                        level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_ADD.get(), SoundSource.BLOCKS, 0.2f, 1.6f + 0.2f * (float)currentShards, false);
                        if (!player.getAbilities().instabuild) {
                            mainHandItem.shrink(1);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                } else {
                    int currentShards;
                    if (ITEM_TO_SYRUP.containsKey(BuiltInRegistries.ITEM.getKey((Object)mainHandItem.getItem()))) {
                        if ((Integer)state.getValue((Property)SHARDS) == 4 && syrup == Syrups.EMPTY) {
                            Syrups newSyrup = (Syrups)((Object)ITEM_TO_SYRUP.get(BuiltInRegistries.ITEM.getKey((Object)mainHandItem.getItem())));
                            level.setBlock(pos, (BlockState)state.setValue((Property)SYRUP_TYPE, (Comparable)((Object)newSyrup)), 3);
                            level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_FILL.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
                            if (!player.getAbilities().instabuild) {
                                mainHandItem.shrink(1);
                                ItemStack dropStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                                if (!player.addItem(dropStack)) {
                                    player.drop(dropStack, false);
                                }
                            }
                        } else if (syrup == Syrups.EMPTY && level.isClientSide) {
                            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".bone_shard_requirement")), true);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (mainHandItem.is(Items.GLASS_BOTTLE)) {
                        if (syrup != Syrups.EMPTY && !((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
                            ItemStack dropStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(syrup.getSyrupBottleItem()));
                            if (!player.getAbilities().instabuild) {
                                mainHandItem.shrink(1);
                                if (!player.addItem(dropStack)) {
                                    player.drop(dropStack, false);
                                }
                            }
                            level.setBlock(pos, (BlockState)state.setValue((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY)), 3);
                            level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_DRAIN.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
                            return ItemInteractionResult.SUCCESS;
                        }
                    } else if (mainHandItem.isEmpty() && syrup == Syrups.EMPTY && (currentShards = ((Integer)state.getValue((Property)SHARDS)).intValue()) > 0) {
                        ItemStack dropStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(FrightsDelightItems.BONE_SHARD), currentShards);
                        if (!player.getAbilities().instabuild && !player.addItem(dropStack)) {
                            player.drop(dropStack, false);
                        }
                        level.setBlock(pos, (BlockState)state.setValue((Property)SHARDS, (Comparable)Integer.valueOf(0)), 3);
                        level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_REMOVE.get(), SoundSource.BLOCKS, 0.2f + 0.1f * (float)currentShards, 1.6f, false);
                        return ItemInteractionResult.SUCCESS;
                    }
                }
            } else if ((Integer)state.getValue((Property)SHARDS) == 4 && syrup != Syrups.EMPTY) {
                ItemStack dropStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(syrup.getLollipopItem()), 4);
                if (!player.getAbilities().instabuild && !player.addItem(dropStack)) {
                    player.drop(dropStack, false);
                }
                level.setBlock(pos, (BlockState)((BlockState)((BlockState)state.setValue((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY))).setValue((Property)SHARDS, (Comparable)Integer.valueOf(0))).setValue((Property)HARDENED, (Comparable)Boolean.valueOf(false)), 3);
                level.playLocalSound(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_COLLECT.get(), SoundSource.BLOCKS, 1.0f, 0.75f, false);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        BlockEntityType blockEntityType = Objects.requireNonNull((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(FrightsDelightBlockEntities.LOLLIPOP_MOLD));
        return LollipopMoldBlock.createTickerHelper(blockEntity, (BlockEntityType)blockEntityType, BaseCandyMoldBlockEntity::hardenTick);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Objects.requireNonNull((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(FrightsDelightBlockEntities.LOLLIPOP_MOLD)).create(pos, state);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int signal = 0;
        int shards = (Integer)state.getValue((Property)SHARDS);
        if (shards > 0) {
            signal += shards;
        }
        if (state.getValue((Property)SYRUP_TYPE) != Syrups.EMPTY) {
            signal += 2;
        }
        if (((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
            signal += 4;
        }
        return signal;
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            super.onRemove(state, level, pos, newState, movedByPiston);
            if (blockEntity instanceof LollipopMoldBlockEntity) {
                NonNullList contents = NonNullList.create();
                if (!((Boolean)state.getValue((Property)HARDENED)).booleanValue()) {
                    int shards = (Integer)state.getValue((Property)SHARDS);
                    if (shards > 0) {
                        contents.add((Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(FrightsDelightItems.BONE_SHARD), shards));
                    }
                } else {
                    Syrups syrup = (Syrups)((Object)state.getValue((Property)SYRUP_TYPE));
                    if (syrup != Syrups.EMPTY) {
                        contents.add((Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(syrup.getLollipopItem()), 4));
                    }
                }
                Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)contents);
            }
        }
    }
}

