/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block.entity;

import com.chefmooon.frightsdelight.common.block.entity.base.BaseBlockEntity;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CandyBasketBlockEntity
extends BaseBlockEntity
implements Container,
Nameable {
    public static final int CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    @Nullable
    private Component name;

    public CandyBasketBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(FrightsDelightBlockEntities.CANDY_BASKET), pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)registries);
        if (tag.contains("CustomName", 8)) {
            this.name = CandyBasketBlockEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)registries);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.itemStacks, (boolean)false, (HolderLookup.Provider)registries);
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)registries));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        ((ItemContainerContents)componentInput.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getItems());
        this.name = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getItems()));
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
        tag.remove("Items");
    }

    public NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.getItems()) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    public boolean addItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (!((ItemStack)this.itemStacks.get(i)).isEmpty()) continue;
            this.itemStacks.set(i, (Object)itemStack.copyWithCount(1));
            this.setChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.isEmpty()) {
            for (int i = 8; i >= 0; --i) {
                ItemStack stack = ContainerHelper.takeItem(this.itemStacks, (int)i);
                if (stack.isEmpty()) continue;
                this.setChanged();
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    public void setItems(ItemContainerContents items) {
        if (items == null) {
            return;
        }
        int slot = 0;
        for (ItemStack itemStack : items.nonEmptyItems()) {
            this.itemStacks.set(slot, (Object)itemStack);
            ++slot;
        }
        this.setChanged();
    }

    public int getFilledSlotsCount() {
        int count = 0;
        for (ItemStack itemStack : this.itemStacks) {
            if (itemStack.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public boolean shuffleInventory() {
        if (!this.isEmpty()) {
            int filledSlots = 0;
            for (int i = 0; i < 9 && !((ItemStack)this.itemStacks.get(i)).isEmpty(); ++i) {
                ++filledSlots;
            }
            if (filledSlots > 1) {
                for (int j = 0; j < filledSlots; ++j) {
                    int randomIndex = (int)(Math.random() * (double)filledSlots);
                    ItemStack temp = (ItemStack)this.itemStacks.get(j);
                    this.itemStacks.set(j, (Object)((ItemStack)this.itemStacks.get(randomIndex)));
                    this.itemStacks.set(randomIndex, (Object)temp);
                }
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)amount);
        if (!itemStack.isEmpty()) {
            this.setChanged();
        }
        return itemStack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.getItems().clear();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.candy_basket");
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }
}

