/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block.entity.base;

import com.chefmooon.frightsdelight.common.block.LollipopMoldBlock;
import com.chefmooon.frightsdelight.common.block.entity.base.BaseBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.Syrups;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseCandyMoldBlockEntity
extends BaseBlockEntity {
    private final int MAX_HARDEN_TIME = 900;
    private int hardenTime;
    private int hardenTimeTotal = 900;

    public BaseCandyMoldBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.hardenTime = tag.getInt("HardenTime");
        this.hardenTimeTotal = tag.getInt("HardenTimeTotal");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("HardenTime", this.hardenTime);
        tag.putInt("HardenTimeTotal", this.hardenTimeTotal);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        super.saveAdditional(compound, provider);
        compound.putInt("HardenTime", this.hardenTime);
        compound.putInt("HardenTimeTotal", this.hardenTimeTotal);
        return compound;
    }

    public static void hardenTick(Level level, BlockPos pos, BlockState state, BaseCandyMoldBlockEntity baseCandyMoldBlockEntity) {
        boolean changed = false;
        Syrups syrup = (Syrups)((Object)state.getValue((Property)LollipopMoldBlock.SYRUP_TYPE));
        if (syrup != Syrups.EMPTY && !((Boolean)state.getValue((Property)LollipopMoldBlock.HARDENED)).booleanValue()) {
            changed = baseCandyMoldBlockEntity.processHardening(level, pos, state, baseCandyMoldBlockEntity);
        }
        if (syrup == Syrups.EMPTY && baseCandyMoldBlockEntity.hardenTime != 0) {
            baseCandyMoldBlockEntity.hardenTime = 0;
            changed = true;
        }
        if (changed) {
            baseCandyMoldBlockEntity.setChanged();
        }
    }

    private boolean processHardening(Level level, BlockPos pos, BlockState state, BaseCandyMoldBlockEntity blockEntity) {
        if (blockEntity.hardenTimeTotal == 0) {
            blockEntity.hardenTimeTotal = 900;
        }
        ++blockEntity.hardenTime;
        if (blockEntity.hardenTime < blockEntity.hardenTimeTotal) {
            this.setChanged();
            return false;
        }
        level.playSound(null, pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_HARDEN.get(), SoundSource.BLOCKS, 0.5f, 0.75f);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LollipopMoldBlock.HARDENED, (Comparable)Boolean.TRUE));
        blockEntity.hardenTime = 0;
        blockEntity.hardenTimeTotal = 0;
        return true;
    }
}

