/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block.entity.dispenser;

import com.chefmooon.frightsdelight.common.block.DrinkableFeastBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DrinkableFeastDispenseBehavior
extends OptionalDispenseItemBehavior {
    protected ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel serverLevel = source.level();
        if (!serverLevel.isClientSide()) {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            Position position = DispenserBlock.getDispensePosition((BlockSource)source);
            BlockPos blockPos = source.pos().relative(direction);
            this.setSuccess(DrinkableFeastDispenseBehavior.tryAddDrinkableFeast(serverLevel, stack, blockPos));
            ItemStack itemStack = stack.split(1);
            this.playSound(source);
            if (this.isSuccess()) {
                DrinkableFeastDispenseBehavior.spawnItem((Level)source.level(), (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE), (int)6, (Direction)direction, (Position)position);
            } else {
                DrinkableFeastDispenseBehavior.spawnItem((Level)source.level(), (ItemStack)itemStack, (int)6, (Direction)direction, (Position)position);
            }
        }
        return stack;
    }

    public static boolean tryAddDrinkableFeast(ServerLevel level, ItemStack item, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof DrinkableFeastBlock) {
            DrinkableFeastBlock drinkableFeastBlock = (DrinkableFeastBlock)block;
            if (item.is(drinkableFeastBlock.servingItem.get()) && (Integer)state.getValue((Property)DrinkableFeastBlock.SERVINGS) < 4) {
                return drinkableFeastBlock.addDrinkFromDispenser((Level)level, pos, state);
            }
        }
        return false;
    }
}

