/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.entity.neoforge;

import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import com.chefmooon.frightsdelight.common.registry.neoforge.FrightsDelightEntityTypesImpl;
import com.chefmooon.frightsdelight.common.registry.neoforge.FrightsDelightItemsImpl;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BoneShardEntityImpl
extends ThrowableItemProjectile {
    public BoneShardEntityImpl(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BoneShardEntityImpl(Level level, LivingEntity entity) {
        super(FrightsDelightEntityTypesImpl.BONE_SHARD.get(), entity, level);
    }

    public BoneShardEntityImpl(Level level, double x, double y, double z) {
        super(FrightsDelightEntityTypesImpl.BONE_SHARD.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return FrightsDelightItemsImpl.BONE_SHARD.get();
    }

    public void handleEntityEvent(byte id) {
        ItemStack entityStack = new ItemStack((ItemLike)this.getDefaultItem());
        if (id == 3) {
            ItemParticleOption iparticledata = new ItemParticleOption(ParticleTypes.ITEM, entityStack);
            for (int i = 0; i < 12; ++i) {
                this.level().addParticle((ParticleOptions)iparticledata, this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f + (double)0.1f, ((double)this.random.nextFloat() * 2.0 - 1.0) * (double)0.1f);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        this.playSound(FrightsDelightSounds.ENTITY_BONE_SHARD_HIT.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(FrightsDelightSounds.ENTITY_BONE_SHARD_HIT.get(), 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.discard();
        }
    }
}

