/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.item;

import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightAdvancements;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CandyBasketItem
extends BlockItem {
    private CandyBasketType candyBasketType;

    public CandyBasketItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public CandyBasketItem(Block block, Item.Properties properties, CandyBasketType type) {
        this(block, properties);
        this.candyBasketType = type;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        InteractionHand offHand = usedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack basketStack = player.getItemInHand(usedHand);
        ItemStack offHandStack = player.getItemInHand(offHand);
        if (player.isCrouching()) {
            return this.shuffleItems(level, player, basketStack);
        }
        if (offHandStack.isEmpty()) {
            return this.removeItem(level, player, offHand, basketStack, offHandStack);
        }
        return this.addItem(level, player, basketStack, offHandStack);
    }

    public InteractionResultHolder<ItemStack> shuffleItems(Level level, Player player, ItemStack basketStack) {
        ItemContainerContents items = (ItemContainerContents)basketStack.get(DataComponents.CONTAINER);
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(List.of());
        if (items != null) {
            for (ItemStack itemStack : items.nonEmptyItems()) {
                itemStackList.add(itemStack);
            }
            if (itemStackList.size() > 1) {
                for (int i = 0; i < itemStackList.size(); ++i) {
                    int randomIndex = (int)(Math.random() * (double)itemStackList.size());
                    ItemStack temp = (ItemStack)itemStackList.get(randomIndex);
                    itemStackList.set(randomIndex, (ItemStack)itemStackList.get(i));
                    itemStackList.set(i, temp);
                }
                basketStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(itemStackList));
                Supplier<SoundEvent> shuffleSound = this.candyBasketType.getShuffleSound();
                if (shuffleSound != null) {
                    level.playLocalSound((Entity)player, shuffleSound.get(), SoundSource.PLAYERS, Math.min(0.3f + 0.04f * (float)itemStackList.size(), 1.0f), 1.0f);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    FrightsDelightAdvancements.CANDY_BASKET_SHUFFLE_TRIGGER.get().trigger(serverPlayer);
                }
                return InteractionResultHolder.success((Object)basketStack);
            }
        }
        return InteractionResultHolder.pass((Object)basketStack);
    }

    public InteractionResultHolder<ItemStack> removeItem(Level level, Player player, InteractionHand offHand, ItemStack basketStack, ItemStack offHandStack) {
        ItemContainerContents items = (ItemContainerContents)basketStack.get(DataComponents.CONTAINER);
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(List.of());
        if (items != null) {
            for (ItemStack itemStack : items.nonEmptyItems()) {
                itemStackList.add(itemStack);
            }
            if (!itemStackList.isEmpty() && offHandStack.isEmpty()) {
                ItemStack toRemove = (ItemStack)itemStackList.removeLast();
                if (!player.getAbilities().instabuild) {
                    player.setItemInHand(offHand, toRemove);
                }
                basketStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(itemStackList));
                Supplier<SoundEvent> removeSound = this.candyBasketType.getRemoveSound();
                if (removeSound != null) {
                    level.playLocalSound((Entity)player, removeSound.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
                }
                return InteractionResultHolder.success((Object)basketStack);
            }
        }
        return InteractionResultHolder.pass((Object)basketStack);
    }

    public InteractionResultHolder<ItemStack> addItem(Level level, Player player, ItemStack basketStack, ItemStack offHandStack) {
        if (!offHandStack.has(DataComponents.FOOD)) {
            return InteractionResultHolder.fail((Object)offHandStack);
        }
        ItemContainerContents items = (ItemContainerContents)basketStack.get(DataComponents.CONTAINER);
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(List.of());
        if (items != null) {
            for (ItemStack itemStack : items.nonEmptyItems()) {
                itemStackList.add(itemStack);
            }
            if (itemStackList.size() < 9 && !offHandStack.isEmpty()) {
                ItemStack toAdd = player.getAbilities().instabuild ? offHandStack.copyWithCount(1) : offHandStack.split(1);
                itemStackList.add(toAdd);
                basketStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(itemStackList));
                Supplier<SoundEvent> addSound = this.candyBasketType.getAddSound();
                if (addSound != null) {
                    level.playLocalSound((Entity)player, addSound.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
                }
                return InteractionResultHolder.success((Object)basketStack);
            }
        }
        return InteractionResultHolder.pass((Object)basketStack);
    }
}

