/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.utility;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class TextUtils {
    private static final MutableComponent NO_EFFECTS = Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY);

    public static MutableComponent getTranslatable(String string, Object ... args) {
        return Component.translatable((String)("frightsdelight." + string), (Object[])args);
    }

    public static ResourceLocation res(String string) {
        return ResourceLocation.fromNamespaceAndPath((String)"frightsdelight", (String)string);
    }

    public static void addFoodEffectTooltip(ItemStack itemIn, Consumer<Component> lores, float durationFactor, float tickRate) {
        TextUtils.addFoodEffectTooltipWithDetail(itemIn, lores, durationFactor, tickRate, false);
    }

    public static void addFoodEffectTooltipWithDetail(ItemStack itemIn, Consumer<Component> lores, float durationFactor, float tickRate) {
        TextUtils.addFoodEffectTooltipWithDetail(itemIn, lores, durationFactor, tickRate, true);
    }

    public static void addFoodEffectTooltipWithDetail(ItemStack stack, Consumer<Component> lores, float durationFactor, float tickRate, boolean detail) {
        FoodProperties foodStats = (FoodProperties)stack.get(DataComponents.FOOD);
        if (foodStats == null) {
            return;
        }
        List effectList = foodStats.effects();
        ArrayList attributeList = Lists.newArrayList();
        if (effectList.isEmpty()) {
            lores.accept((Component)NO_EFFECTS);
        } else {
            for (FoodProperties.PossibleEffect possibleEffect : effectList) {
                MobEffectInstance instance = possibleEffect.effect();
                int effectChance = (int)(100.0f * possibleEffect.probability());
                MutableComponent iformattabletextcomponent = Component.translatable((String)instance.getDescriptionId());
                MobEffect effect = (MobEffect)instance.getEffect().value();
                effect.createModifiers(instance.getAmplifier(), (attributeHolder, attributeModifier) -> attributeList.add(new Pair(attributeHolder, attributeModifier)));
                if (instance.getAmplifier() > 0) {
                    iformattabletextcomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.translatable((String)("potion.potency." + instance.getAmplifier()))});
                }
                if (instance.getDuration() > 20) {
                    iformattabletextcomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)durationFactor, (float)tickRate)});
                }
                if (detail) {
                    iformattabletextcomponent = iformattabletextcomponent.append((Component)Component.literal((String)(" " + effectChance + "%")));
                }
                lores.accept((Component)iformattabletextcomponent.withStyle(effect.getCategory().getTooltipFormatting()));
            }
        }
        if (!attributeList.isEmpty()) {
            lores.accept(CommonComponents.EMPTY);
            lores.accept((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : attributeList) {
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double amount = modifier.amount();
                double formattedAmount = modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? modifier.amount() : modifier.amount() * 100.0;
                if (amount > 0.0) {
                    lores.accept((Component)Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(formattedAmount), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                lores.accept((Component)Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(formattedAmount *= -1.0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }
}

