/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.integration.wthit.provider;

import com.chefmooon.frightsdelight.common.block.FrightsDelightBushBlock;
import com.chefmooon.frightsdelight.common.block.SoulBerryBushBlock;
import com.chefmooon.frightsdelight.common.block.WitherBerryBushBlock;
import com.chefmooon.frightsdelight.common.utility.TextUtils;
import com.chefmooon.frightsdelight.integration.wthit.FrightsDelightWailiaPlugin;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.PairComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public enum BerryBushInfoProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        Block block;
        if (config.getBoolean(FrightsDelightWailiaPlugin.Options.CROP_PROGRESS) && (block = accessor.getBlock()) instanceof FrightsDelightBushBlock) {
            FrightsDelightBushBlock bush = (FrightsDelightBushBlock)block;
            BerryBushInfoProvider.addGrowthProgressTooltip(tooltip, (float)((Integer)accessor.getBlockState().getValue((Property)bush.getAgeProperty())).intValue() / (float)bush.getMaxAge());
        }
        if (config.getBoolean(FrightsDelightWailiaPlugin.Options.BUSH_GROWTH_CONDITION)) {
            BerryBushInfoProvider.addBushGrowthConditionTooltip(tooltip, accessor);
        }
        if (config.getBoolean(FrightsDelightWailiaPlugin.Options.BUSH_TRANSFORM_CONDITION)) {
            BerryBushInfoProvider.addTransformConditionTooltip(tooltip, accessor);
        }
    }

    private static void addGrowthProgressTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.addLine((ITooltipComponent)new PairComponent((Component)Component.translatable((String)"tooltip.waila.crop_growth"), (Component)Component.literal((String)String.format("%.0f%%", Float.valueOf(growthValue)))));
        } else {
            tooltip.addLine((ITooltipComponent)new PairComponent((Component)Component.translatable((String)"tooltip.waila.crop_growth"), (Component)Component.translatable((String)"tooltip.waila.crop_mature")));
        }
    }

    private static void addBushGrowthConditionTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        Block block = accessor.getBlock();
        if (block instanceof FrightsDelightBushBlock) {
            FrightsDelightBushBlock frightsDelightBushBlock = (FrightsDelightBushBlock)block;
            int lightLevel = accessor.getWorld().getRawBrightness(accessor.getPosition().above(), 0);
            boolean growthCondition = (Boolean)accessor.getBlockState().getValue((Property)frightsDelightBushBlock.getGrowConditionProperty());
            if (frightsDelightBushBlock instanceof SoulBerryBushBlock) {
                BerryBushInfoProvider.addGrowthConditionTooltip(tooltip, growthCondition && SoulBerryBushBlock.hasGrowBrightness(lightLevel));
            } else if (frightsDelightBushBlock instanceof WitherBerryBushBlock) {
                BerryBushInfoProvider.addGrowthConditionTooltip(tooltip, growthCondition && WitherBerryBushBlock.hasGrowBrightness(lightLevel));
            }
        }
    }

    private static void addTransformConditionTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        FrightsDelightBushBlock frightsDelightBushBlock;
        Block block = accessor.getBlock();
        if (block instanceof FrightsDelightBushBlock && (frightsDelightBushBlock = (FrightsDelightBushBlock)block) instanceof SoulBerryBushBlock) {
            SoulBerryBushBlock soulBerryBushBlock = (SoulBerryBushBlock)frightsDelightBushBlock;
            if ((Integer)accessor.getBlockState().getValue((Property)soulBerryBushBlock.getAgeProperty()) == 3) {
                int lightLevel = accessor.getWorld().getRawBrightness(accessor.getPosition().above(), 0);
                boolean transformCondition = (Boolean)accessor.getBlockState().getValue((Property)soulBerryBushBlock.getTransformConditionProperty());
                BerryBushInfoProvider.addBooleanTooltip(tooltip, "tooltip.waila.bush_transform", transformCondition && SoulBerryBushBlock.hasTransformBrightness(lightLevel));
            }
        }
    }

    private static void addGrowthConditionTooltip(ITooltip tooltip, boolean growthCondition) {
        tooltip.addLine((ITooltipComponent)new PairComponent((Component)Component.translatable((String)"tooltip.waila.crop_growable"), (Component)(growthCondition ? Component.translatable((String)"tooltip.waila.true") : Component.translatable((String)"tooltip.waila.false"))));
    }

    private static void addBooleanTooltip(ITooltip tooltip, String translationKey, boolean growthCondition) {
        tooltip.addLine((ITooltipComponent)new PairComponent((Component)TextUtils.getTranslatable(translationKey, new Object[0]), (Component)(growthCondition ? Component.translatable((String)"tooltip.waila.true") : Component.translatable((String)"tooltip.waila.false"))));
    }
}

