/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.entity.CandyBasketBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractCandyBasketBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private CandyBasketType candyBasketType = CandyBasketType.NONE;

    public AbstractCandyBasketBlock(BlockBehaviour.Properties properties, CandyBasketType type) {
        this(properties);
        this.candyBasketType = type;
    }

    public AbstractCandyBasketBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Objects.requireNonNull((BlockEntityType)BuiltInRegistries.f_257049_.m_7745_(FrightsDelightBlockEntities.CANDY_BASKET)).m_155264_(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CandyBasketBlockEntity)) {
            return InteractionResult.PASS;
        }
        ItemStack mainHandItem = player.m_21120_(hand);
        if (!player.m_36341_()) {
            if (!mainHandItem.m_41619_() || player.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && !player.m_21120_(InteractionHand.OFF_HAND).m_41619_()) {
                if (!mainHandItem.m_41614_()) {
                    return InteractionResult.FAIL;
                }
                boolean addItem = AbstractCandyBasketBlock.addItem(mainHandItem, level, pos);
                if (addItem) {
                    Supplier<SoundEvent> addSound;
                    if (!player.m_150110_().f_35937_) {
                        mainHandItem.m_41620_(1);
                    }
                    if ((addSound = this.candyBasketType.getAddSound()) != null) {
                        level.m_245747_(pos, addSound.get(), SoundSource.BLOCKS, 0.4f, 1.0f, false);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                ItemStack removeItem = AbstractCandyBasketBlock.removeItem(level, pos);
                if (!removeItem.m_41619_()) {
                    Supplier<SoundEvent> removeSound;
                    if (!player.m_150110_().f_35937_ && player.m_150109_().m_36054_(removeItem)) {
                        player.m_36176_(removeItem, false);
                    }
                    if ((removeSound = this.candyBasketType.getRemoveSound()) != null) {
                        level.m_245747_(pos, removeSound.get(), SoundSource.BLOCKS, 0.4f, 0.6f, false);
                    }
                    return InteractionResult.SUCCESS;
                }
                level.m_245747_(pos, FrightsDelightSounds.BLOCK_CANDY_BASKET_EMPTY.get(), SoundSource.BLOCKS, 0.4f, 0.6f, false);
            }
        }
        return InteractionResult.PASS;
    }

    public CandyBasketType getCandyBasketType() {
        return this.candyBasketType;
    }

    public static boolean addItem(ItemStack itemStack, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.addItem(itemStack);
        }
        return false;
    }

    public static ItemStack removeItem(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.removeItem();
        }
        return ItemStack.f_41583_;
    }

    public static boolean shuffleInventory(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            return candyBasketBlockEntity.shuffleInventory();
        }
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            int count = 0;
            for (int i = 0; i < container.m_6643_(); ++i) {
                if (container.m_8020_(i).m_41619_()) continue;
                ++count;
            }
            if (count > 0) {
                return count * 14 / container.m_6643_() + 1;
            }
        }
        return 0;
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack itemStack = super.m_7397_(level, pos, state);
        BlockEntityType blockEntityType = (BlockEntityType)BuiltInRegistries.f_257049_.m_7745_(FrightsDelightBlockEntities.CANDY_BASKET);
        if (blockEntityType != null && level.m_7702_(pos) instanceof CandyBasketBlockEntity) {
            level.m_141902_(pos, blockEntityType).ifPresent(blockEntity -> blockEntity.m_187476_(itemStack));
        }
        return itemStack;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)stack);
        if (compoundTag != null && compoundTag.m_128425_("Items", 9)) {
            NonNullList nonNullList = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)nonNullList);
            for (ItemStack itemStack : nonNullList) {
                if (itemStack.m_41619_()) continue;
                tooltip.add((Component)itemStack.m_41786_().m_6881_());
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            if (!level.f_46443_ && player.m_7500_() && !candyBasketBlockEntity.m_7983_()) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                candyBasketBlockEntity.m_187476_(itemStack);
                if (candyBasketBlockEntity.m_8077_()) {
                    itemStack.m_41714_(candyBasketBlockEntity.m_7770_());
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
            level.m_46672_(pos, Blocks.f_50016_);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof CandyBasketBlockEntity) {
            CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
            candyBasketBlockEntity.setCustomName(stack.m_41786_());
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CandyBasketBlockEntity) {
                level.m_46717_(pos, state.m_60734_());
            }
            super.m_6810_(state, level, pos, newState, movedByPiston);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

