/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.block.entity.base.BaseCandyMoldBlockEntity;
import com.chefmooon.frightsdelight.common.block.state.properties.FrightsDelightBlockStateProperties;
import com.chefmooon.frightsdelight.common.block.state.properties.SyrupTypeProperty;
import com.chefmooon.frightsdelight.common.data.types.Syrups;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AbstractMoldBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    protected static Map<ResourceLocation, Syrups> ITEM_TO_SYRUP = Map.of(Syrups.ROTTEN_FLESH.getSyrupBottleItem(), Syrups.ROTTEN_FLESH, Syrups.SLIMEAPPLE.getSyrupBottleItem(), Syrups.SLIMEAPPLE, Syrups.SPIDEREYE.getSyrupBottleItem(), Syrups.SPIDEREYE, Syrups.GHASTTEAR.getSyrupBottleItem(), Syrups.GHASTTEAR, Syrups.SOUL_BERRY.getSyrupBottleItem(), Syrups.SOUL_BERRY, Syrups.WITHER_BERRY.getSyrupBottleItem(), Syrups.WITHER_BERRY, Syrups.COBWEB.getSyrupBottleItem(), Syrups.COBWEB);
    public static final SyrupTypeProperty SYRUP_TYPE = FrightsDelightBlockStateProperties.SYRUP_TYPE;
    public static final BooleanProperty HARDENED = FrightsDelightBlockStateProperties.HARDENED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);

    protected AbstractMoldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY))).m_61124_((Property)HARDENED, (Comparable)Boolean.FALSE));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return stateIn;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SYRUP_TYPE, HARDENED, FACING, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return null;
    }

    public boolean m_48673_(BlockState state) {
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof BaseCandyMoldBlockEntity) {
            level.m_46717_(pos, state.m_60734_());
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Syrups syrup;
        if (Configuration.candyMoldParticles() && (syrup = (Syrups)((Object)state.m_61143_((Property)SYRUP_TYPE))) != Syrups.EMPTY && !((Boolean)state.m_61143_((Property)HARDENED)).booleanValue()) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = (double)pos.m_123342_() + 0.2;
            double f = (double)pos.m_123343_() + 0.5;
            if (random.m_188503_(4) == 0) {
                SimpleParticleType particleData;
                SimpleParticleType simpleParticleType = particleData = syrup.getParticle() != null ? syrup.getParticle().get() : null;
                if (particleData != null) {
                    level.m_7106_((ParticleOptions)particleData, d + (random.m_188500_() - 0.5) / 2.0, e + (1.0 - random.m_188500_()) / 20.0, f + (random.m_188500_() - 0.5) / 2.0, 0.0, 0.0, 0.0);
                    if (syrup.getAnimateSound() != null && level.f_46441_.m_188503_(10) == 0) {
                        level.m_245747_(pos, syrup.getAnimateSound().get(), SoundSource.BLOCKS, 0.2f, 0.8f, false);
                    }
                }
            }
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

