/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import com.chefmooon.frightsdelight.common.utility.TextUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DrinkableFeastBlock
extends Block {
    public static final int MAX_SERVINGS = 4;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)4);
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    public Supplier<Item> servingItem;
    public ParticleOptions particleData;

    public DrinkableFeastBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = null;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public DrinkableFeastBlock(Supplier<Item> servingItem, ParticleOptions particleData, BlockBehaviour.Properties properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = particleData;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(4)));
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public int getMaxServings() {
        return 4;
    }

    public ItemStack getServingItem(BlockState state) {
        return new ItemStack((ItemLike)this.servingItem.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, SERVINGS});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack serving = this.getServingItem(state);
        ItemStack heldItem = player.m_21120_(hand);
        if (level.m_5776_() && (heldItem.m_150930_(serving.m_41720_()) ? this.addDrink(level, pos, state, player, hand).m_19077_() : this.dispenseDrink(level, pos, state, player, hand).m_19077_())) {
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_150930_(serving.m_41720_())) {
            return this.addDrink(level, pos, state, player, hand);
        }
        return this.dispenseDrink(level, pos, state, player, hand);
    }

    protected InteractionResult dispenseDrink(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)this.getServingsProperty());
        if (servings == 0) {
            return InteractionResult.FAIL;
        }
        if (servings > 0) {
            ItemStack serving = this.getServingItem(state);
            ItemStack heldItem = player.m_21120_(hand);
            if (heldItem.m_150930_(Items.f_42590_)) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                world.m_5594_(null, pos, FrightsDelightSounds.BLOCK_DRINKABLE_FEAST_REMOVE.get(), SoundSource.BLOCKS, 0.8f, 0.8f);
                if (!player.m_7500_()) {
                    heldItem.m_41774_(1);
                    if (!player.m_150109_().m_36054_(serving)) {
                        player.m_36176_(serving, false);
                    }
                }
            } else {
                player.m_5661_((Component)TextUtils.getTranslatable("container.punch_bowl", new Object[0]), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult addDrink(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)this.getServingsProperty());
        if (servings < 4) {
            ItemStack heldItem = player.m_21120_(hand);
            ItemStack container = new ItemStack((ItemLike)Items.f_42590_);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings + 1)), 3);
            world.m_5594_(null, pos, FrightsDelightSounds.BLOCK_DRINKABLE_FEAST_ADD.get(), SoundSource.BLOCKS, 0.8f, 0.8f);
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                if (!player.m_150109_().m_36054_(container)) {
                    player.m_36176_(container, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean addDrinkFromDispenser(Level world, BlockPos pos, BlockState state) {
        int servings = (Integer)state.m_61143_((Property)this.getServingsProperty());
        if (servings < 4) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings + 1)), 3);
            world.m_5594_(null, pos, FrightsDelightSounds.BLOCK_DRINKABLE_FEAST_REMOVE.get(), SoundSource.PLAYERS, 0.8f, 0.8f);
            return true;
        }
        return false;
    }

    public void animate(BlockState state, Level level, BlockPos pos, SoundEvent soundEvent, RandomSource random) {
        int servings = (Integer)state.m_61143_((Property)this.getServingsProperty());
        if (Configuration.drinkableFeastParticles() && this.particleData != null && servings > 0) {
            double d = (double)pos.m_123341_() + 0.5;
            double e = (double)pos.m_123342_() + 0.03 + (double)servings / 8.0;
            double f = (double)pos.m_123343_() + 0.5;
            int chance = 10 - servings * 2;
            if (random.m_188503_(Math.max(chance, 1)) == 0) {
                level.m_7106_(this.particleData, d + (random.m_188500_() - 0.5) / 2.0, e + (1.0 - random.m_188500_()) / 20.0, f + (random.m_188500_() - 0.5) / 2.0, 0.0, 0.0, 0.0);
                if (level.f_46441_.m_188503_(10) == 0) {
                    level.m_245747_(pos, soundEvent, SoundSource.BLOCKS, 0.2f, 0.8f, false);
                }
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return DrinkableFeastBlock.getOutputSignal((Integer)state.m_61143_((Property)SERVINGS));
    }

    public static int getOutputSignal(int servings) {
        return servings * 2;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

