/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.AbstractMoldBlock;
import com.chefmooon.frightsdelight.common.block.entity.LollipopMoldBlockEntity;
import com.chefmooon.frightsdelight.common.block.entity.base.BaseCandyMoldBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.Syrups;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightItems;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LollipopMoldBlock
extends AbstractMoldBlock {
    public static final IntegerProperty SHARDS = IntegerProperty.m_61631_((String)"shards", (int)0, (int)4);

    public LollipopMoldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SHARDS, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY))).m_61124_((Property)HARDENED, (Comparable)Boolean.FALSE));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SHARDS});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LollipopMoldBlockEntity) {
            ItemStack mainHandItem = player.m_21120_(hand);
            Syrups syrup = (Syrups)((Object)state.m_61143_((Property)SYRUP_TYPE));
            if (!((Boolean)state.m_61143_((Property)HARDENED)).booleanValue()) {
                if (mainHandItem.m_150930_((Item)BuiltInRegistries.f_257033_.m_7745_(FrightsDelightItems.BONE_SHARD))) {
                    int currentShards = (Integer)state.m_61143_((Property)SHARDS);
                    if (currentShards < 4) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SHARDS, (Comparable)Integer.valueOf(currentShards + 1)), 3);
                        level.m_245747_(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_ADD.get(), SoundSource.BLOCKS, 0.2f, 1.6f + 0.2f * (float)currentShards, false);
                        if (!player.m_150110_().f_35937_) {
                            mainHandItem.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    int currentShards;
                    if (ITEM_TO_SYRUP.containsKey(BuiltInRegistries.f_257033_.m_7981_((Object)mainHandItem.m_41720_()))) {
                        if ((Integer)state.m_61143_((Property)SHARDS) == 4 && syrup == Syrups.EMPTY) {
                            Syrups newSyrup = (Syrups)((Object)ITEM_TO_SYRUP.get(BuiltInRegistries.f_257033_.m_7981_((Object)mainHandItem.m_41720_())));
                            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SYRUP_TYPE, (Comparable)((Object)newSyrup)), 3);
                            level.m_245747_(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_FILL.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
                            if (!player.m_150110_().f_35937_) {
                                mainHandItem.m_41774_(1);
                                ItemStack dropStack = new ItemStack((ItemLike)Items.f_42590_);
                                if (!player.m_36356_(dropStack)) {
                                    player.m_36176_(dropStack, false);
                                }
                            }
                        } else if (syrup == Syrups.EMPTY && level.f_46443_) {
                            player.m_5661_((Component)Component.m_237115_((String)(this.m_7705_() + ".bone_shard_requirement")), true);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (mainHandItem.m_150930_(Items.f_42590_)) {
                        if (syrup != Syrups.EMPTY && !((Boolean)state.m_61143_((Property)HARDENED)).booleanValue()) {
                            ItemStack dropStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(syrup.getSyrupBottleItem()));
                            if (!player.m_150110_().f_35937_) {
                                mainHandItem.m_41774_(1);
                                if (!player.m_36356_(dropStack)) {
                                    player.m_36176_(dropStack, false);
                                }
                            }
                            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY)), 3);
                            level.m_245747_(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_DRAIN.get(), SoundSource.BLOCKS, 0.8f, 1.0f, false);
                            return InteractionResult.SUCCESS;
                        }
                    } else if (mainHandItem.m_41619_() && syrup == Syrups.EMPTY && (currentShards = ((Integer)state.m_61143_((Property)SHARDS)).intValue()) > 0) {
                        ItemStack dropStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(FrightsDelightItems.BONE_SHARD), currentShards);
                        if (!player.m_150110_().f_35937_ && !player.m_36356_(dropStack)) {
                            player.m_36176_(dropStack, false);
                        }
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SHARDS, (Comparable)Integer.valueOf(0)), 3);
                        level.m_245747_(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_REMOVE.get(), SoundSource.BLOCKS, 0.2f + 0.1f * (float)currentShards, 1.6f, false);
                        return InteractionResult.SUCCESS;
                    }
                }
            } else if ((Integer)state.m_61143_((Property)SHARDS) == 4 && syrup != Syrups.EMPTY) {
                ItemStack dropStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(syrup.getLollipopItem()), 4);
                if (!player.m_150110_().f_35937_ && !player.m_36356_(dropStack)) {
                    player.m_36176_(dropStack, false);
                }
                level.m_7731_(pos, (BlockState)((BlockState)((BlockState)state.m_61124_((Property)SYRUP_TYPE, (Comparable)((Object)Syrups.EMPTY))).m_61124_((Property)SHARDS, (Comparable)Integer.valueOf(0))).m_61124_((Property)HARDENED, (Comparable)Boolean.valueOf(false)), 3);
                level.m_245747_(pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_COLLECT.get(), SoundSource.BLOCKS, 1.0f, 0.75f, false);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        BlockEntityType blockEntityType = Objects.requireNonNull((BlockEntityType)BuiltInRegistries.f_257049_.m_7745_(FrightsDelightBlockEntities.LOLLIPOP_MOLD));
        return LollipopMoldBlock.m_152132_(blockEntity, (BlockEntityType)blockEntityType, BaseCandyMoldBlockEntity::hardenTick);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return Objects.requireNonNull((BlockEntityType)BuiltInRegistries.f_257049_.m_7745_(FrightsDelightBlockEntities.LOLLIPOP_MOLD)).m_155264_(pos, state);
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        int signal = 0;
        int shards = (Integer)state.m_61143_((Property)SHARDS);
        if (shards > 0) {
            signal += shards;
        }
        if (state.m_61143_((Property)SYRUP_TYPE) != Syrups.EMPTY) {
            signal += 2;
        }
        if (((Boolean)state.m_61143_((Property)HARDENED)).booleanValue()) {
            signal += 4;
        }
        return signal;
    }

    @Override
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof LollipopMoldBlockEntity) {
            NonNullList contents = NonNullList.m_122779_();
            if (!((Boolean)state.m_61143_((Property)HARDENED)).booleanValue()) {
                int shards = (Integer)state.m_61143_((Property)SHARDS);
                if (shards > 0) {
                    contents.add((Object)new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(FrightsDelightItems.BONE_SHARD), shards));
                }
            } else {
                Syrups syrup = (Syrups)((Object)state.m_61143_((Property)SYRUP_TYPE));
                if (syrup != Syrups.EMPTY) {
                    contents.add((Object)new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(syrup.getLollipopItem()), 4));
                }
            }
            Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)contents);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }
}

