/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.block.FrightsDelightBushBlock;
import com.chefmooon.frightsdelight.common.block.WitherBerryBushBlock;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlocks;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightDamageTypes;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightItems;
import com.chefmooon.frightsdelight.common.tag.FrightsDelightTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class SoulBerryBushBlock
extends FrightsDelightBushBlock {
    public static final int GROW_RANGE = 5;
    public static final TagKey<Block> GROW_CONDITION_BLOCK = FrightsDelightTags.SOUL_BERRY_BUSH_GROW_CONDITIION;
    public static final BooleanProperty TRANSFORM_CONDITION = BooleanProperty.m_61465_((String)"transform_condition");

    public SoulBerryBushBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)TRANSFORM_CONDITION, (Comparable)Boolean.FALSE);
        return (BlockState)state.m_61124_((Property)GROW_CONDITION, (Comparable)Boolean.valueOf(SoulBerryBushBlock.hasGrowthCondition((LevelAccessor)level, pos, 5, GROW_CONDITION_BLOCK)));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(FrightsDelightItems.SOUL_BERRY));
    }

    @Override
    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState blockState;
        int i = (Integer)state.m_61143_((Property)AGE);
        this.updateConditions(state, (LevelAccessor)level, pos);
        if (((Boolean)state.m_61143_((Property)GROW_CONDITION)).booleanValue() && i < 3 && random.m_188503_(5) == 0 && SoulBerryBushBlock.hasGrowBrightness(level.m_45524_(pos.m_7494_(), 0))) {
            blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.m_7731_(pos, blockState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockState));
        }
        if (i == 3 && SoulBerryBushBlock.hasTransformBrightness(level.m_45524_(pos.m_7494_(), 0)) && SoulBerryBushBlock.hasTransformCondition((LevelAccessor)level, pos)) {
            blockState = (BlockState)((BlockState)((Block)BuiltInRegistries.f_256975_.m_7745_(FrightsDelightBlocks.WITHER_BERRY_BUSH)).m_49966_().m_61124_((Property)WitherBerryBushBlock.GROW_CONDITION, (Comparable)Boolean.TRUE)).m_61124_((Property)WitherBerryBushBlock.AGE, (Comparable)Integer.valueOf(3));
            level.m_5594_((Player)null, pos, SoundEvents.f_12396_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            level.m_7731_(pos, blockState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockState));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int i;
        boolean bl;
        if (!level.m_5776_()) {
            this.updateConditions(state, (LevelAccessor)level, pos);
        }
        boolean bl2 = bl = (i = ((Integer)state.m_61143_((Property)AGE)).intValue()) == 3;
        if (!bl && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + level.f_46441_.m_188503_(2);
            SoulBerryBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(FrightsDelightItems.SOUL_BERRY), j + (bl ? 1 : 0)));
            level.m_5594_((Player)null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1));
            level.m_7731_(pos, blockState, 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.updateConditions(state, (LevelAccessor)level, pos);
        super.m_214148_(level, random, pos, state);
    }

    @Override
    public DamageSource getDamageSource(Level level) {
        return FrightsDelightDamageTypes.getSimpleDamageSource(level, FrightsDelightDamageTypes.SOUL_BERRY_BUSH);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!level.m_5776_()) {
            this.updateConditions(state, level, pos);
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TRANSFORM_CONDITION});
    }

    public static boolean hasTransformCondition(LevelAccessor level, BlockPos pos) {
        int TRANSFORM_GROW_RANGE = 1;
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)BlockPos.m_122022_((long)BlockPos.m_121910_((long)pos.m_121878_(), (int)(-TRANSFORM_GROW_RANGE), (int)-1, (int)(-TRANSFORM_GROW_RANGE))), (BlockPos)BlockPos.m_122022_((long)BlockPos.m_121910_((long)pos.m_121878_(), (int)TRANSFORM_GROW_RANGE, (int)1, (int)TRANSFORM_GROW_RANGE)))) {
            if (!level.m_8055_(blockPos).m_204336_(WitherBerryBushBlock.GROW_CONDITION_BLOCK)) continue;
            return true;
        }
        return false;
    }

    public void updateTransformCondition(BlockState state, LevelAccessor level, BlockPos pos, boolean oldCondition) {
        boolean newCondition = SoulBerryBushBlock.hasTransformCondition(level, pos);
        if (newCondition != oldCondition) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)TRANSFORM_CONDITION, (Comparable)Boolean.valueOf(newCondition)), 2);
        }
    }

    public void updateConditions(BlockState state, LevelAccessor level, BlockPos pos) {
        this.updateGrowthCondition(state, level, pos, 5, GROW_CONDITION_BLOCK, (Boolean)state.m_61143_((Property)GROW_CONDITION));
        this.updateTransformCondition(state, level, pos, (Boolean)state.m_61143_((Property)TRANSFORM_CONDITION));
    }

    public static boolean hasGrowBrightness(int lightLevel) {
        return lightLevel >= 9;
    }

    public static boolean hasTransformBrightness(int lightLevel) {
        return lightLevel <= 7;
    }

    public BooleanProperty getTransformConditionProperty() {
        return TRANSFORM_CONDITION;
    }
}

