/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block.entity;

import com.chefmooon.frightsdelight.common.block.entity.base.BaseBlockEntity;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CandyBasketBlockEntity
extends BaseBlockEntity
implements Container,
Nameable {
    public static final int CONTAINER_SIZE = 9;
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    @Nullable
    private Component name;

    public CandyBasketBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BuiltInRegistries.f_257049_.m_7745_(FrightsDelightBlockEntities.CANDY_BASKET), pos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.itemStacks);
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18976_((CompoundTag)tag, this.itemStacks, (boolean)false);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    public int m_6643_() {
        return this.itemStacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.getItems()) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    public boolean addItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (!((ItemStack)this.itemStacks.get(i)).m_41619_()) continue;
            this.itemStacks.set(i, (Object)itemStack.m_255036_(1));
            this.m_6596_();
            return true;
        }
        return false;
    }

    public ItemStack removeItem() {
        if (!this.m_7983_()) {
            for (int i = 8; i >= 0; --i) {
                ItemStack stack = ContainerHelper.m_18966_(this.itemStacks, (int)i);
                if (stack.m_41619_()) continue;
                this.m_6596_();
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public int getFilledSlotsCount() {
        int count = 0;
        for (ItemStack itemStack : this.itemStacks) {
            if (itemStack.m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public boolean shuffleInventory() {
        if (!this.m_7983_()) {
            int filledSlots = 0;
            for (int i = 0; i < 9 && !((ItemStack)this.itemStacks.get(i)).m_41619_(); ++i) {
                ++filledSlots;
            }
            if (filledSlots > 1) {
                for (int j = 0; j < filledSlots; ++j) {
                    int randomIndex = (int)(Math.random() * (double)filledSlots);
                    ItemStack temp = (ItemStack)this.itemStacks.get(j);
                    this.itemStacks.set(j, (Object)((ItemStack)this.itemStacks.get(randomIndex)));
                    this.itemStacks.set(randomIndex, (Object)temp);
                }
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.getItems(), (int)slot, (int)amount);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.getItems(), (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.getItems().clear();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.candy_basket");
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }
}

