/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block.entity.base;

import com.chefmooon.frightsdelight.common.block.LollipopMoldBlock;
import com.chefmooon.frightsdelight.common.block.entity.base.BaseBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.Syrups;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseCandyMoldBlockEntity
extends BaseBlockEntity {
    private final int MAX_HARDEN_TIME = 900;
    private int hardenTime;
    private int hardenTimeTotal = 900;

    public BaseCandyMoldBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.hardenTime = tag.m_128451_("HardenTime");
        this.hardenTimeTotal = tag.m_128451_("HardenTimeTotal");
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("HardenTime", this.hardenTime);
        tag.m_128405_("HardenTimeTotal", this.hardenTimeTotal);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        super.m_183515_(compound);
        compound.m_128405_("HardenTime", this.hardenTime);
        compound.m_128405_("HardenTimeTotal", this.hardenTimeTotal);
        return compound;
    }

    public static void hardenTick(Level level, BlockPos pos, BlockState state, BaseCandyMoldBlockEntity baseCandyMoldBlockEntity) {
        boolean changed = false;
        Syrups syrup = (Syrups)((Object)state.m_61143_((Property)LollipopMoldBlock.SYRUP_TYPE));
        if (syrup != Syrups.EMPTY && !((Boolean)state.m_61143_((Property)LollipopMoldBlock.HARDENED)).booleanValue()) {
            changed = baseCandyMoldBlockEntity.processHardening(level, pos, state, baseCandyMoldBlockEntity);
        }
        if (syrup == Syrups.EMPTY && baseCandyMoldBlockEntity.hardenTime != 0) {
            baseCandyMoldBlockEntity.hardenTime = 0;
            changed = true;
        }
        if (changed) {
            baseCandyMoldBlockEntity.m_6596_();
        }
    }

    private boolean processHardening(Level level, BlockPos pos, BlockState state, BaseCandyMoldBlockEntity blockEntity) {
        if (blockEntity.hardenTimeTotal == 0) {
            blockEntity.hardenTimeTotal = 900;
        }
        ++blockEntity.hardenTime;
        if (blockEntity.hardenTime < blockEntity.hardenTimeTotal) {
            this.m_6596_();
            return false;
        }
        level.m_5594_(null, pos, FrightsDelightSounds.BLOCK_CANDY_MOLD_HARDEN.get(), SoundSource.BLOCKS, 0.5f, 0.75f);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)LollipopMoldBlock.HARDENED, (Comparable)Boolean.TRUE));
        blockEntity.hardenTime = 0;
        blockEntity.hardenTimeTotal = 0;
        return true;
    }
}

