/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block.forge;

import com.chefmooon.frightsdelight.common.block.AbstractCandyBasketBlock;
import com.chefmooon.frightsdelight.common.block.entity.CandyBasketBlockEntity;
import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightAdvancements;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightSounds;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class AbstractCandyBasketBlockImpl
extends AbstractCandyBasketBlock {
    public AbstractCandyBasketBlockImpl(BlockBehaviour.Properties properties, CandyBasketType type) {
        super(properties, type);
    }

    @Mod.EventBusSubscriber(modid="frightsdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ShuffleEvent {
        @SubscribeEvent
        public static InteractionResult onSneak(PlayerInteractEvent.RightClickBlock event) {
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            Player player = event.getEntity();
            ItemStack heldStack = player.m_21205_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (player.m_36341_() && blockEntity instanceof CandyBasketBlockEntity) {
                CandyBasketBlockEntity candyBasketBlockEntity = (CandyBasketBlockEntity)blockEntity;
                if (!candyBasketBlockEntity.m_7983_()) {
                    boolean shuffled = AbstractCandyBasketBlock.shuffleInventory(level, pos);
                    if (shuffled) {
                        Supplier<SoundEvent> shuffleSound;
                        Block block = level.m_8055_(pos).m_60734_();
                        if (block instanceof AbstractCandyBasketBlockImpl) {
                            AbstractCandyBasketBlockImpl candyBasketBlock = (AbstractCandyBasketBlockImpl)block;
                            v0 = candyBasketBlock.getCandyBasketType().getShuffleSound();
                        } else {
                            v0 = shuffleSound = null;
                        }
                        if (shuffleSound != null) {
                            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, shuffleSound.get(), SoundSource.PLAYERS, Math.min(0.3f + 0.04f * (float)candyBasketBlockEntity.getFilledSlotsCount(), 1.0f), 1.0f, false);
                        }
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            FrightsDelightAdvancements.CANDY_BASKET_SHUFFLE_TRIGGER.trigger(serverPlayer);
                        }
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, FrightsDelightSounds.BLOCK_CANDY_BASKET_EMPTY.get(), SoundSource.BLOCKS, 0.4f, 0.6f, false);
                }
            }
            return InteractionResult.PASS;
        }
    }
}

