/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.item;

import com.chefmooon.frightsdelight.common.data.types.CandyBasketType;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightAdvancements;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightBlockEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CandyBasketItem
extends BlockItem {
    private CandyBasketType candyBasketType;

    public CandyBasketItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public CandyBasketItem(Block block, Item.Properties properties, CandyBasketType type) {
        this(block, properties);
        this.candyBasketType = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        InteractionHand offHand = usedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack basketStack = player.m_21120_(usedHand);
        ItemStack offHandStack = player.m_21120_(offHand);
        if (player.m_6047_()) {
            return this.shuffleItems(level, player, basketStack);
        }
        if (offHandStack.m_41619_()) {
            return this.removeItem(level, player, offHand, basketStack, offHandStack);
        }
        return this.addItem(level, player, basketStack, offHandStack);
    }

    public InteractionResultHolder<ItemStack> shuffleItems(Level level, Player player, ItemStack basketStack) {
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)basketStack);
        if (compoundTag != null && compoundTag.m_128425_("Items", 9)) {
            NonNullList nonNullList = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)nonNullList);
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(List.of());
            if (!nonNullList.isEmpty()) {
                for (ItemStack itemStack : nonNullList) {
                    if (itemStack.m_41619_()) continue;
                    itemStackList.add(itemStack);
                }
                if (itemStackList.size() > 1) {
                    int i;
                    for (i = 0; i < itemStackList.size(); ++i) {
                        int randomIndex = (int)(Math.random() * (double)itemStackList.size());
                        ItemStack temp = (ItemStack)itemStackList.get(randomIndex);
                        itemStackList.set(randomIndex, (ItemStack)itemStackList.get(i));
                        itemStackList.set(i, temp);
                    }
                    nonNullList.clear();
                    for (i = 0; i < itemStackList.size(); ++i) {
                        nonNullList.set(i, (Object)((ItemStack)itemStackList.get(i)));
                    }
                    ContainerHelper.m_18973_((CompoundTag)compoundTag, (NonNullList)nonNullList);
                    basketStack.m_41700_("Items", (Tag)compoundTag);
                    Supplier<SoundEvent> shuffleSound = this.candyBasketType.getShuffleSound();
                    if (shuffleSound != null) {
                        level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), shuffleSound.get(), SoundSource.PLAYERS, Math.min(0.3f + 0.04f * (float)itemStackList.size(), 1.0f), 1.0f, false);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        FrightsDelightAdvancements.CANDY_BASKET_SHUFFLE_TRIGGER.trigger(serverPlayer);
                    }
                    return InteractionResultHolder.m_19090_((Object)basketStack);
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)basketStack);
    }

    public InteractionResultHolder<ItemStack> removeItem(Level level, Player player, InteractionHand offHand, ItemStack basketStack, ItemStack offHandStack) {
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)basketStack);
        if (compoundTag != null && compoundTag.m_128425_("Items", 9)) {
            NonNullList nonNullList = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)nonNullList);
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(List.of());
            if (!nonNullList.isEmpty()) {
                for (ItemStack itemStack : nonNullList) {
                    if (itemStack.m_41619_()) continue;
                    itemStackList.add(itemStack);
                }
                if (!itemStackList.isEmpty() && offHandStack.m_41619_()) {
                    int i;
                    ItemStack toRemove = ItemStack.f_41583_;
                    for (i = itemStackList.size() - 1; i >= 0; --i) {
                        ItemStack candidate = (ItemStack)itemStackList.get(i);
                        if (candidate.m_41619_()) continue;
                        toRemove = candidate.m_41777_();
                        itemStackList.remove(i);
                        break;
                    }
                    if (!toRemove.m_41619_()) {
                        if (!player.m_150110_().f_35937_) {
                            player.m_21008_(offHand, toRemove);
                        }
                        nonNullList.clear();
                        for (i = 0; i < itemStackList.size(); ++i) {
                            nonNullList.set(i, (Object)((ItemStack)itemStackList.get(i)));
                        }
                        ContainerHelper.m_18973_((CompoundTag)compoundTag, (NonNullList)nonNullList);
                        basketStack.m_41700_("Items", (Tag)compoundTag);
                        Supplier<SoundEvent> removeSound = this.candyBasketType.getRemoveSound();
                        if (removeSound != null) {
                            level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), removeSound.get(), SoundSource.PLAYERS, 0.4f, 1.0f, false);
                        }
                        return InteractionResultHolder.m_19090_((Object)basketStack);
                    }
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)basketStack);
    }

    public InteractionResultHolder<ItemStack> addItem(Level level, Player player, ItemStack basketStack, ItemStack offHandStack) {
        if (!offHandStack.m_41614_()) {
            return InteractionResultHolder.m_19100_((Object)offHandStack);
        }
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)basketStack);
        if (compoundTag != null) {
            if (compoundTag.m_128425_("Items", 9)) {
                NonNullList nonNullList = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)nonNullList);
                ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>(List.of());
                if (!nonNullList.isEmpty()) {
                    for (ItemStack itemStack : nonNullList) {
                        if (itemStack.m_41619_()) continue;
                        itemStackList.add(itemStack);
                    }
                    if (itemStackList.size() < 9 && !offHandStack.m_41619_()) {
                        ItemStack toAdd = player.m_150110_().f_35937_ ? offHandStack.m_255036_(1) : offHandStack.m_41620_(1);
                        itemStackList.add(toAdd);
                        nonNullList.clear();
                        for (int i = 0; i < itemStackList.size(); ++i) {
                            nonNullList.set(i, (Object)((ItemStack)itemStackList.get(i)));
                        }
                        ContainerHelper.m_18973_((CompoundTag)compoundTag, (NonNullList)nonNullList);
                        basketStack.m_41700_("Items", (Tag)compoundTag);
                        Supplier<SoundEvent> addSound = this.candyBasketType.getAddSound();
                        if (addSound != null) {
                            level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), addSound.get(), SoundSource.PLAYERS, 0.4f, 1.0f, false);
                        }
                        return InteractionResultHolder.m_19090_((Object)basketStack);
                    }
                }
            }
        } else {
            Supplier<SoundEvent> addSound;
            CompoundTag newTag = new CompoundTag();
            NonNullList nonNullList = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            if (!offHandStack.m_41619_()) {
                ItemStack toAdd = player.m_150110_().f_35937_ ? offHandStack.m_255036_(1) : offHandStack.m_41620_(1);
                nonNullList.set(0, (Object)toAdd);
                ContainerHelper.m_18973_((CompoundTag)newTag, (NonNullList)nonNullList);
                basketStack.m_41700_("Items", (Tag)newTag);
                BlockItem.m_186338_((ItemStack)basketStack, (BlockEntityType)Objects.requireNonNull((BlockEntityType)BuiltInRegistries.f_257049_.m_7745_(FrightsDelightBlockEntities.CANDY_BASKET)), (CompoundTag)newTag);
            }
            if ((addSound = this.candyBasketType.getAddSound()) != null) {
                level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), addSound.get(), SoundSource.PLAYERS, 0.4f, 1.0f, false);
            }
            return InteractionResultHolder.m_19090_((Object)basketStack);
        }
        return InteractionResultHolder.m_19098_((Object)basketStack);
    }
}

