/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FrightsDelightBushBlock
extends BushBlock
implements BonemealableBlock {
    private static final float HURT_SPEED_THRESHOLD = 0.003f;
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape SAPLING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty GROW_CONDITION = BooleanProperty.m_61465_((String)"grow_condition");

    public FrightsDelightBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)GROW_CONDITION, (Comparable)Boolean.FALSE)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return (Integer)state.m_61143_((Property)AGE) < 3 ? MID_GROWTH_SHAPE : super.m_5940_(state, level, pos, context);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && entity.m_6095_() != EntityType.f_20452_ && entity.m_6095_() != EntityType.f_20550_) {
            entity.m_7601_(state, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(level.f_46443_ || (Integer)state.m_61143_((Property)AGE) <= 0 || entity.f_19790_ == entity.m_20185_() && entity.f_19792_ == entity.m_20189_())) {
                double d = Math.abs(entity.m_20185_() - entity.f_19790_);
                double e = Math.abs(entity.m_20189_() - entity.f_19792_);
                if (d >= (double)0.003f || e >= (double)0.003f) {
                    entity.m_6469_(this.getDamageSource(level), 1.0f);
                }
            }
        }
    }

    public DamageSource getDamageSource(Level level) {
        return level.m_269111_().m_269555_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_204336_(BlockTags.f_13080_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        return this.m_6266_(level.m_8055_(blockPos), (BlockGetter)level, blockPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE, GROW_CONDITION});
    }

    public static boolean hasGrowthCondition(LevelAccessor level, BlockPos pos, int range, TagKey<Block> growCondition) {
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)BlockPos.m_122022_((long)BlockPos.m_121910_((long)pos.m_121878_(), (int)(-range), (int)-1, (int)(-range))), (BlockPos)BlockPos.m_122022_((long)BlockPos.m_121910_((long)pos.m_121878_(), (int)range, (int)1, (int)range)))) {
            if (!level.m_8055_(blockPos).m_204336_(growCondition)) continue;
            return true;
        }
        return false;
    }

    public void updateGrowthCondition(BlockState state, LevelAccessor level, BlockPos pos, int range, TagKey<Block> growCondition, boolean oldCondition) {
        boolean newCondition = FrightsDelightBushBlock.hasGrowthCondition(level, pos, range, growCondition);
        if (newCondition != oldCondition) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)GROW_CONDITION, (Comparable)Boolean.valueOf(newCondition)), 2);
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)GROW_CONDITION)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1))), 2);
        }
    }

    public int getMaxAge() {
        return 3;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public BooleanProperty getGrowConditionProperty() {
        return GROW_CONDITION;
    }
}

