/*
 * Decompiled with CFR 0.152.
 */
package com.chefmooon.frightsdelight.common.block;

import com.chefmooon.frightsdelight.common.Configuration;
import com.chefmooon.frightsdelight.common.registry.FrightsDelightShapes;
import com.chefmooon.frightsdelight.common.tag.CommonTags;
import com.chefmooon.frightsdelight.common.utility.VoxelShapeUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GlassCupBlock
extends Block {
    public static final int MAX_SERVINGS = 3;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public Supplier<Item> servingItem;
    public ParticleOptions particleData;
    protected final ConcurrentHashMap<Integer, VoxelShape[]> CUP_SHAPES;

    public GlassCupBlock(Supplier<Item> servingItem, BlockBehaviour.Properties properties) {
        this(servingItem, null, properties);
    }

    public GlassCupBlock(Supplier<Item> servingItem, ParticleOptions particleData, BlockBehaviour.Properties properties) {
        super(properties);
        this.servingItem = servingItem;
        this.particleData = particleData;
        this.CUP_SHAPES = GlassCupBlock.buildShapes();
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(0)));
    }

    private static ConcurrentHashMap<Integer, VoxelShape[]> buildShapes() {
        ConcurrentHashMap<Integer, VoxelShape[]> result = new ConcurrentHashMap<Integer, VoxelShape[]>();
        result.put(0, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_1));
        result.put(1, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_2));
        result.put(2, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_3));
        result.put(3, VoxelShapeUtil.getRotatedShapes(FrightsDelightShapes.CUP_NORTH_SERVINGS_4));
        return result;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.m_5776_()) {
            if (heldStack.m_204117_(CommonTags.C_TOOLS)) {
                return this.rotate(level, pos, state, player);
            }
            if (heldStack.m_150930_(this.servingItem.get())) {
                return this.addServingFromHand(level, pos, state, player, hand);
            }
            if (heldStack.m_41619_()) {
                return this.removeServingToHand(level, pos, state, player, hand);
            }
        }
        if (heldStack.m_204117_(CommonTags.C_TOOLS)) {
            return this.rotate(level, pos, state, player);
        }
        if (heldStack.m_150930_(this.servingItem.get())) {
            return this.addServingFromHand(level, pos, state, player, hand);
        }
        if (heldStack.m_41619_()) {
            return this.removeServingToHand(level, pos, state, player, hand);
        }
        return InteractionResult.FAIL;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, SERVINGS});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        return this.CUP_SHAPES.containsKey(servings) ? this.CUP_SHAPES.get(servings)[((Direction)state.m_61143_((Property)FACING)).m_122416_()] : Shapes.m_83040_();
    }

    public String m_7705_() {
        return this.servingItem.get().m_5524_();
    }

    protected InteractionResult rotate(Level level, BlockPos pos, BlockState state, Player player) {
        if (player.m_20191_().m_272282_(pos.m_252807_()) < 0.5) {
            return InteractionResult.CONSUME;
        }
        if (level.m_7731_(pos, (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122427_()), 3)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult addServingFromHand(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        if (servings < 3) {
            ItemStack heldItem = player.m_21120_(hand);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings + 1)), 3);
            level.m_5594_(player, pos, SoundEvents.f_11986_, SoundSource.BLOCKS, 0.8f, 0.6f);
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected InteractionResult removeServingToHand(Level level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)SERVINGS);
        ItemStack servingItem = new ItemStack((ItemLike)this.servingItem.get());
        if (servings == 0) {
            level.m_7471_(pos, false);
            level.m_5594_(player, pos, SoundEvents.f_11986_, SoundSource.BLOCKS, 0.8f, 0.8f);
            if (!player.m_7500_() && !player.m_150109_().m_36054_(servingItem)) {
                player.m_36176_(servingItem, false);
            }
            return InteractionResult.SUCCESS;
        }
        if (servings > 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servings - 1)), 3);
            level.m_5594_(player, pos, SoundEvents.f_11986_, SoundSource.BLOCKS, 0.8f, 0.8f);
            if (!player.m_7500_() && !player.m_150109_().m_36054_(servingItem)) {
                player.m_36176_(servingItem, false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public IntegerProperty getServingsProperty() {
        return SERVINGS;
    }

    public void animate(BlockState state, Level level, BlockPos pos, SoundEvent soundEvent, RandomSource random) {
        if (Configuration.glassCupParticles() && this.particleData != null) {
            int servings = (Integer)state.m_61143_((Property)this.getServingsProperty()) + 1;
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            double baseX = (double)pos.m_123341_() + 0.5;
            double baseY = (double)pos.m_123342_() + 0.5;
            double baseZ = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < servings; ++i) {
                if (random.m_188503_(4) != 0) continue;
                double spread = 0.3;
                double xOffset = 0.0;
                double zOffset = 0.0;
                zOffset = switch (i) {
                    case 0 -> {
                        xOffset = -spread;
                        yield -spread;
                    }
                    case 1 -> {
                        xOffset = spread;
                        yield -spread;
                    }
                    case 2 -> {
                        xOffset = spread;
                        yield spread;
                    }
                    case 3 -> {
                        xOffset = -spread;
                        yield spread;
                    }
                    default -> zOffset;
                };
                double rotatedX = 0.0;
                double rotatedZ = 0.0;
                rotatedZ = switch (facing) {
                    case Direction.NORTH -> {
                        rotatedX = xOffset;
                        yield zOffset;
                    }
                    case Direction.SOUTH -> {
                        rotatedX = -xOffset;
                        yield -zOffset;
                    }
                    case Direction.EAST -> {
                        rotatedX = -zOffset;
                        yield xOffset;
                    }
                    case Direction.WEST -> {
                        rotatedX = zOffset;
                        yield -xOffset;
                    }
                    default -> rotatedZ;
                };
                double smallVariation = 0.05;
                level.m_7106_(this.particleData, baseX + (rotatedX += (random.m_188500_() - 0.5) * smallVariation), baseY + (1.0 - random.m_188500_()) / 20.0, baseZ + (rotatedZ += (random.m_188500_() - 0.5) * smallVariation), 0.0, 0.0, 0.0);
                if (level.f_46441_.m_188503_(10) != 0) continue;
                level.m_245747_(pos, soundEvent, SoundSource.BLOCKS, 0.2f, 0.8f, false);
            }
        }
    }
}

